/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;

public class CloseRepeatAction
extends Action {
    public static final String NAME = "CLOSE_REPEAT";

    public CloseRepeatAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.getEditor().getTablature().getCaret().getSongCoords();
        this.showCloseRepeatDialog(this.getEditor().getTablature().getShell(), measureCoords, songCoords);
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        this.redraw();
    }

    public void showCloseRepeatDialog(Shell shell, final MeasureCoords measureCoords, final SongCoords songCoords) {
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginTop = 20;
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 10;
            shell2.setLayout((Layout)gridLayout);
            shell2.setText(TuxGuitar.getProperty("repetitions"));
            int n = measureCoords.getMeasure().getNumberOfRepetitions();
            if (n < 1) {
                n = 1;
            }
            Label label = new Label((Composite)shell2, 0);
            label.setText(TuxGuitar.getProperty("repeat.number-of-repetitions"));
            final Text text = new Text((Composite)shell2, 2048);
            text.setLayoutData((Object)new GridData(50, 13));
            text.setText(Integer.toString(n));
            Button button = new Button((Composite)shell2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)new GridData(128));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CloseRepeatAction.this.closeRepeat(measureCoords, songCoords, Integer.parseInt(text.getText()));
                    shell2.dispose();
                }
            });
            Button button2 = new Button((Composite)shell2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n2 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n3 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n2, n3);
        }
    }

    private void closeRepeat(MeasureCoords measureCoords, SongCoords songCoords, int n) {
        n = Math.abs(n);
        songCoords.changeCloseRepeat(measureCoords.getMeasure().getStart(), n);
        this.updateTablature();
    }
}

