/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.FretBoardEditor;
import org.herac.tuxguitar.gui.SongMixerViewer;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.gui.language.LanguageManager;
import org.herac.tuxguitar.song.managers.SongManager;

public class TuxGuitar {
    private static TuxGuitar instance;
    private String basePath = new File("").getAbsolutePath() + File.separator;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private LanguageManager languageManager;
    private Composite sashComposite;
    private TablatureEditor tablatureEditor;
    private SongMixerViewer mixer;
    private FretBoardEditor fretBoardEditor;
    private ActionContainer actionContainer;
    private ItemContainerManager itemContainerManager;
    static /* synthetic */ Class class$org$herac$tuxguitar$gui$TuxGuitar;

    public static void main(String[] stringArray) {
        TuxGuitar.instance().displayGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TuxGuitar instance() {
        if (instance == null) {
            Class clazz = class$org$herac$tuxguitar$gui$TuxGuitar == null ? (class$org$herac$tuxguitar$gui$TuxGuitar = TuxGuitar.class$("org.herac.tuxguitar.gui.TuxGuitar")) : class$org$herac$tuxguitar$gui$TuxGuitar;
            synchronized (clazz) {
                instance = new TuxGuitar();
            }
        }
        return instance;
    }

    private void initLanguage() {
        this.languageManager = new LanguageManager();
        this.languageManager.setLanguage("en");
    }

    public void displayGUI() {
        this.initLanguage();
        this.display = new Display();
        Shell shell = this.getSplashShell(this.display);
        shell.open();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        this.shell.setImage(new Image((Device)this.display, TuxGuitar.getResourcePath(this, "icon.png")));
        this.songManager = new SongManager();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        this.mixer = new SongMixerViewer(this.tablatureEditor);
        this.fretBoardEditor = new FretBoardEditor(this.tablatureEditor);
        this.initActions();
        this.initItems();
        this.createComposites((Composite)this.shell);
        this.shell.setMinimumSize(640, 480);
        this.shell.open();
        this.setDefaults();
        shell.close();
        shell.dispose();
        this.itemContainerManager.updateItems();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.songManager.getPlayer().close();
        this.display.dispose();
        System.exit(0);
    }

    private Shell getSplashShell(Display display) {
        Shell shell = new Shell(display, 262152);
        final Image image = new Image((Device)display, TuxGuitar.getResourcePath(this, "splash.png"));
        int n = image.getBounds().width;
        int n2 = image.getBounds().height;
        int n3 = (display.getBounds().width - display.getBounds().x) / 2 - n / 2;
        int n4 = (display.getBounds().height - display.getBounds().y) / 2 - n2 / 2;
        shell.setBounds(n3, n4, n, n2);
        shell.setImage(new Image((Device)display, TuxGuitar.getResourcePath(this, "icon.png")));
        shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.drawImage(image, 0, 0);
            }
        });
        return shell;
    }

    public void createComposites(Composite composite) {
        this.sashComposite = new Composite(composite, 0);
        this.sashComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 40);
        formData.bottom = new FormAttachment(100, 0);
        this.sashComposite.setLayoutData((Object)formData);
        final Sash sash = new Sash(this.sashComposite, 258);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(75, 0);
        sash.setLayoutData((Object)formData);
        this.tablatureEditor.showTablature(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        this.tablatureEditor.getTablature().setLayoutData(formData);
        this.mixer.showMixer(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)sash, 10);
        formData.bottom = new FormAttachment(100, 0);
        this.mixer.getMixer().setLayoutData(formData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ((TuxGuitar)TuxGuitar.this).sashComposite.getBounds().height;
                int n2 = selectionEvent.y * 100 / n;
                ((FormData)sash.getLayoutData()).top = new FormAttachment(n2, 0);
            }
        });
        sash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                sash.getParent().layout();
            }
        });
        this.fretBoardEditor.showFretBoard(composite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.sashComposite, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoardEditor.getFretBoard().setLayoutData(formData);
    }

    public void setDefaults() {
        this.showFretBoard();
    }

    public void showFretBoard() {
        this.fretBoardEditor.getFretBoard().setVisible(true);
        this.updateSashNumerator();
        this.shell.layout();
    }

    public void hideFretBoard() {
        this.fretBoardEditor.getFretBoard().setVisible(false);
        ((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
        this.shell.setMinimumSize(640, 480);
        this.fretBoardEditor.getFretBoard().setVisible(false);
        this.updateSashNumerator();
        this.shell.layout();
    }

    public void updateSashNumerator() {
        FormData formData = (FormData)this.sashComposite.getLayoutData();
        if (this.fretBoardEditor.getFretBoard().isVisible()) {
            int n = 100 - this.fretBoardEditor.getFretBoard().getHeight() * 100 / (this.shell.getBounds().height - 40);
            if (n < 0) {
                n = 0;
            }
            formData.bottom.numerator = n;
            this.shell.setMinimumSize(730, 520);
        } else {
            ((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
            this.shell.setMinimumSize(640, 480);
        }
    }

    public FretBoardEditor getFretBoardEditor() {
        return this.fretBoardEditor;
    }

    private void initItems() {
        this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
        this.itemContainerManager.createMenu(this.shell);
        this.itemContainerManager.createToolbar(this.shell);
    }

    private void initActions() {
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }

    public void redraw() {
        this.tablatureEditor.getTablature().redraw();
        this.fretBoardEditor.getFretBoard().redraw();
        this.mixer.getMixer().redraw();
    }

    public void loadProperties() {
        this.itemContainerManager.loadProperties();
        this.mixer.getMixer().loadProperties();
        this.fretBoardEditor.getFretBoard().loadProperties();
    }

    public Action getAction(String string) {
        return this.actionContainer.getAction(string);
    }

    public ItemContainerManager getItemContainerManager() {
        return this.itemContainerManager;
    }

    public ActionContainer getActionContainer() {
        return this.actionContainer;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public static String getProperty(String string) {
        return TuxGuitar.instance().languageManager.getProperty(string);
    }

    public static String getResourcePath(Object object, String string) {
        return TuxGuitar.instance().basePath + "files" + File.separator + string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

