/*
 * Created on 13-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.play.models.midiplayer;

import java.util.Iterator;
import java.util.List;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongSequence {    
    private static int DEFAULT_BEND = 64;
    /**
     * Sequencia de la cancion
     */
    private Sequence sequence;
    /**
     * Cancion
     */
    private SongManager songManager;
    /**
     * Repeticiones de la Cancion
     */
    private boolean[] usedChannels;
    
    
    public SongSequence(SongManager songManager) {
        this.songManager = songManager;
        this.usedChannels = this.songManager.getUsedChannels();
    }

    public void createSongSecuence() {
        this.createSecuence();
    }

    public Sequence getSongSecuence() {
        return this.sequence;
    }
    
    
    
    
    /**
     * Crea la cancion
     */        
    private void createSecuence() {
        try {
            sequence = new Sequence(Sequence.PPQ, 1);

            Iterator it = this.songManager.getSong().getTracks().iterator();
            for (int trackIdx = 0; trackIdx < this.songManager.getSong().getTracks().size(); trackIdx++) {
                SongTrack songTrack = (SongTrack) this.songManager.getSong().getTracks().get(trackIdx);
                createTrack(songTrack,(trackIdx == 0),getFreeChannelForEffect());
            }

            addTimeSignature(new TimeSignature(4, new Duration(Duration.QUARTER)), 0, sequence.getTracks()[0]);
            addTempo(new Tempo(100), 0, sequence.getTracks()[0]);
           
            
        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /**
     * Crea las pistas de la cancion
     */        
    private void createTrack(SongTrack songTrack,boolean firstTrack,int effectChannel) {
        try {
            Track midiTrack = sequence.createTrack();
            makeInstrument(midiTrack, songTrack.getChannel(), songTrack.getInstrument());
            addBend(midiTrack,0,DEFAULT_BEND,songTrack.getChannel());
            
            //------controlo las repeticiones-------
            long repeatStart = 1000;
            boolean repeatOpen = true;
            long repeatEnd = 0;
            long startMove = 0;
            int repeatStartIndex = 0;
            int repeatNumber = 0;
            //--------------------------------------

            if(effectChannel >= 0){
                makeInstrument(midiTrack,effectChannel, songTrack.getInstrument());
            }            
            
            Measure prevMeasure = null;
            for (int measureIdx = 0; measureIdx < songTrack.getMeasures().size(); measureIdx++) {
                Measure measure = (Measure) songTrack.getMeasures().get(measureIdx);
                                    
                if(firstTrack){
                    makeMeasureStartMetaMessage(midiTrack, measureIdx, measure,startMove);
                }
                //agrego las notas
                makeNotes(midiTrack, songTrack, measure, measureIdx, startMove,effectChannel);

                //agrego el tempo y ritmo------------------------------------
                addTimeSignature(measure, prevMeasure,startMove, midiTrack);
                addTempo(measure, prevMeasure,startMove,midiTrack);
                //-----------------------------------------------------------

                //guardo el indice de el compas donde empieza una repeticion
                if (measure.isRepeatStart()) {
                    repeatStartIndex = measureIdx;
                    repeatStart = measure.getStart();
                    repeatOpen = true;
                }

                //si hay una repeticion la hago
                if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
                    if (repeatNumber < measure.getNumberOfRepetitions()) {
                        repeatEnd = measure.getStart() + measure.getLength();
                        startMove += repeatEnd - repeatStart;
                        measureIdx = repeatStartIndex - 1;
                        repeatNumber++;
                    } else {
                        repeatStart = 0;
                        repeatNumber = 0;
                        repeatEnd = 0;
                        repeatOpen = false;
                    }
                }

                prevMeasure = measure;
            }

        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /**
     * Crea las notas del compas
     */    
    private void makeNotes(Track midiTrack, SongTrack songTrack, Measure measure, int measureIdx, long startMove,int effectChannel) {        
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            if (!note.isTiedNote()) {
                int key = note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                long start = note.getStart() + startMove;
                long duration = getRealNoteDuration(note, songTrack.getMeasures(), measureIdx, noteIdx);
                int velocity = note.getVelocity();
                int channel = songTrack.getChannel();
                
                if(!songTrack.isPercusionTrack()){
                    Note prevNote = getPrevNote(note,songTrack.getMeasures(),measureIdx,noteIdx);
                    if(prevNote != null && prevNote.getEffect().isHammer()){
                        velocity -= 25;
                    }
                }
                if(note.getEffect().hasEffects() && effectChannel >= 0 && !songTrack.isPercusionTrack()){              
                    makeNote(midiTrack, key, start, duration, velocity,effectChannel);                    
                    if(note.getEffect().isBend()){
                        makeBend(midiTrack,start,duration,note.getEffect().getBend(),effectChannel);
                    }else if(note.getEffect().isSlide()){        
                        Note nextNote = getNextNote(note,songTrack.getMeasures(),measureIdx,noteIdx);
                        makeSlide(midiTrack,note,nextNote,startMove,effectChannel);                               
                	}else if(note.getEffect().isVibrato()){
                        makeVibrato(midiTrack,start,duration,effectChannel);
                    }
                    this.usedChannels[effectChannel] = true;
                }else{                
                    makeNote(midiTrack, key, start, duration, velocity,channel);
                }
            }
        }

    }

    
    /**
     * Crea una nota en la posicion start
     */
    private void makeNote(Track track, int key, long start, long duration, int velocity, int channel) {
        try {
            ShortMessage messageOn = new ShortMessage();
            ShortMessage messageOff = new ShortMessage();

            messageOn.setMessage(ShortMessage.NOTE_ON, channel, key, velocity);
            messageOff.setMessage(ShortMessage.NOTE_OFF, channel, key, velocity);

            track.add(new MidiEvent(messageOn, start));
            track.add(new MidiEvent(messageOff, start + duration));

        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /**
     * Crea el instrumento para la pista
     */
    private void makeInstrument(Track track, int channel, int instrument) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(ShortMessage.PROGRAM_CHANGE, channel, instrument, 0);
            track.add(new MidiEvent(message, 0));
        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /**
     * Agrega un Time Signature si es distinto al anterior
     */
    private void addTimeSignature(Measure currMeasure, Measure prevMeasure,long startMove,Track track) throws InvalidMidiDataException {
        boolean addTimeSignature = false;
        if (prevMeasure == null) {
            addTimeSignature = true;
        } else {
            int currNumerator = currMeasure.getTimeSignature().getNumerator();
            int currValue = currMeasure.getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getTimeSignature().getDenominator().getValue();
            if (currNumerator != prevNumerator || currValue != prevValue) {
                addTimeSignature = true;
            }
        }
        if (addTimeSignature) {
            addTimeSignature(currMeasure.getTimeSignature(), currMeasure.getStart() + startMove, track);
        }
    }

    /**
     * Agrega un Time Signature
     */
    private void addTimeSignature(TimeSignature timeSignature, long tick, Track track) throws InvalidMidiDataException {
        MetaMessage metaMessage = new MetaMessage();
        byte data[] = new byte[4];
        data[0] = (byte) timeSignature.getNumerator();

        if (timeSignature.getDenominator().getValue() == 1) {
            data[1] = 0;
        } else if (timeSignature.getDenominator().getValue() == 2) {
            data[1] = 1;
        } else if (timeSignature.getDenominator().getValue() == 4) {
            data[1] = 2;
        } else if (timeSignature.getDenominator().getValue() == 8) {
            data[1] = 3;
        } else if (timeSignature.getDenominator().getValue() == 16) {
            data[1] = 4;
        } else if (timeSignature.getDenominator().getValue() == 32) {
            data[1] = 5;
        } else {
            throw new InvalidMidiDataException();
        }

        data[2] = (byte) (96 / timeSignature.getDenominator().getValue());
        data[3] = 8;
        metaMessage.setMessage(0x58, data, 4);

        MidiEvent midiEvent = new MidiEvent(metaMessage, tick);
        track.add(midiEvent);
    }

    /**
     * Agrega un Tempo si es distinto al anterior
     */
    private void addTempo(Measure currMeasure, Measure prevMeasure,long startMove, Track track) throws InvalidMidiDataException {
        boolean addTempo = false;
        if (prevMeasure == null) {
            addTempo = true;
        } else {
            if (currMeasure.getTempo().getValue() != prevMeasure.getTempo().getValue()) {
                addTempo = true;
            }
        }
        if (addTempo) {
            addTempo(currMeasure.getTempo(), currMeasure.getStart() + startMove, track);
        }
    }

    /**
     * Agrega un Tempo
     */
    private void addTempo(Tempo tempo, long tick, Track track) throws InvalidMidiDataException {
        int usq = (int) tempo.getInMillis();
        MetaMessage metaMessage = new MetaMessage();
        byte[] data = new byte[3];

        data[0] = (byte) ((usq >> 16) & 0x00FF);
        data[1] = (byte) ((usq >> 8) & 0x00FF);
        data[2] = (byte) ((usq) & 0x00FF);
        metaMessage.setMessage(0x51, data, 3);

        MidiEvent midiEvent = new MidiEvent(metaMessage, tick);
        track.add(midiEvent);
    }

    /**
     * Retorna la Duracion real de una nota, verificando si tiene otras ligadas
     */
    private long getRealNoteDuration(Note note, List measures, int measureIndex, int noteIndex) {
        long duration = note.getDuration().getTime();
        noteIndex++;
        for (int mIdx = measureIndex; mIdx < measures.size(); mIdx++) {
            Measure measure = (Measure) measures.get(mIdx);
            for (int nIdx = noteIndex; nIdx < measure.getNotes().size(); nIdx++) {
                Note nextNote = (Note) measure.getNotes().get(nIdx);
                if (!nextNote.equals(note)) {
                    if (nextNote.getString() == note.getString()) {
                        if (nextNote.isTiedNote()) {
                            duration += nextNote.getDuration().getTime();
                        } else {
                            return duration;
                        }
                    }
                }
            }
            noteIndex = 0;
        }
        return duration;
    }

    
    /**
     * Agrega un Meta Message para el evento de cada compas
     */
    public void makeMeasureStartMetaMessage(Track track, int index, Measure measure,long startMove) {
        MetaMessage metaMessage = new MetaMessage();

        String start = Long.toString(measure.getStart());
        byte data[] = start.getBytes();
                
        try {
            metaMessage.setMessage(MeasureStartMetaEventListener.MEASURE_START, data, data.length);
            MidiEvent event = new MidiEvent(metaMessage, measure.getStart() + startMove);
            track.add(event);
        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }
    
    
    
    
    
    
    
    
    private void addBend(Track track, long tick,int bend, int channel) {
        try {
            bend = (bend > 127)?127:bend;
            ShortMessage bendMessage = new ShortMessage();                                    
            bendMessage.setMessage(ShortMessage.PITCH_BEND,channel,0, bend);
            
            track.add(new MidiEvent(bendMessage, tick));            
        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }         
    
    
    public void makeVibrato(Track track,long start, long duration,int channel){
        long end = start + duration;
        
        while(start < end){            
            start = ((start + 160 > end)?end:start + 160);            
            addBend(track,start,DEFAULT_BEND,channel);
            start = ((start + 160 > end)?end:start + 160);
            addBend(track,start,DEFAULT_BEND + 8,channel);
        }
        addBend(track,start,DEFAULT_BEND,channel);
    }
    
    
    public void makeBend(Track track,long start, long duration, BendEffect bend, int channel){                        
        List points = bend.getPoints();
        for(int i=0;i<points.size();i++){
            BendEffect.BendPoint point = (BendEffect.BendPoint)points.get(i);
            
            int value = DEFAULT_BEND + (point.getValue() * 8);
            long bendStart = start + point.getTime(duration);            
            addBend(track,bendStart,value,channel);
            
            if(points.size() > i + 1){
                BendEffect.BendPoint nextPoint = (BendEffect.BendPoint)points.get(i + 1);
                int nextValue = DEFAULT_BEND + (nextPoint.getValue() * 8);
                long nextBendStart = start + nextPoint.getTime(duration);            
                
                double width = (nextBendStart - bendStart);
                width = ((nextValue - value) > 0)?width / (nextValue - value):16;
                
                //ascendente
                if(value < nextValue){
                    while(value < nextValue){            
                        value ++;       
                        bendStart +=width;
                        addBend(track,bendStart,value,channel);
                    }
                 //descendente
                }else if(value > nextValue){
                    while(value > nextValue){            
                        value --;       
                        bendStart +=width;
                        addBend(track,bendStart,value,channel);
                    }
                }
                
            }
        }       
        addBend(track,start + duration,DEFAULT_BEND,channel);
    }    
    
    
    
    public void makeSlide(Track track,Note note,Note nextNote,long startMove,int channel){
        if(nextNote != null){
            long tick = nextNote.getStart() + startMove;
            int value = Math.abs(nextNote.getValue() - note.getValue());
            value = (value > 2)?2:value;
            
            if(nextNote.getValue() > note.getValue()){      
                int bend = DEFAULT_BEND + (31 * value);
                while(bend > DEFAULT_BEND){ 
                    tick -= (40 / value);
                    addBend(track,tick,bend,channel);                    
                    bend -= 10;
                }
                
            }else if(nextNote.getValue() < note.getValue()){
                int bend = DEFAULT_BEND;
                while(bend > (DEFAULT_BEND - (31 * value))){ 
                    tick -= (40 / value);
                    addBend(track,tick,bend,channel);                    
                    bend -= 10;
                }                
                
            }
            
            addBend(track,nextNote.getStart() + startMove,DEFAULT_BEND,channel);  
        }
    }

    private Note getNextNote(Note note,List measures, int measureIndex, int noteIndex){
        Note nextNote = null;    
        noteIndex ++;
        for (int mIdx = measureIndex; mIdx < measures.size(); mIdx++) {
            Measure measure = (Measure) measures.get(mIdx);
            for (int nIdx = noteIndex; nIdx < measure.getNotes().size(); nIdx++) {
                Note currNote = (Note) measure.getNotes().get(nIdx);
                if(currNote.getString() == note.getString() && currNote.getStart() > note.getStart()){
                    if(nextNote == null || currNote.getStart() < nextNote.getStart()){
                        nextNote = currNote;
                    }
                }
            }
            noteIndex = 0;
        }
        
        return nextNote;        
    }    
    
        
    private Note getPrevNote(Note note,List measures, int measureIndex, int noteIndex){
        Note prevNote = null;                
        for (int mIdx = measureIndex; mIdx >= 0; mIdx--) {
            Measure measure = (Measure) measures.get(mIdx);
            if(noteIndex < 0){
                noteIndex = measure.getNotes().size();
            }
            for (int nIdx = noteIndex - 1; nIdx >= 0; nIdx--) {
                Note currNote = (Note) measure.getNotes().get(nIdx);
                if(currNote.getString() == note.getString() && currNote.getStart() < note.getStart()){
                    if(prevNote == null || currNote.getStart() > prevNote.getStart()){
                        prevNote = currNote;
                    }
                }
            }
            if(prevNote != null){
                break;
            }
            noteIndex = -1;
        }
        
        return prevNote;        
    }
    
    
    private int getFreeChannelForEffect(){
        for(int i = 0;i < this.usedChannels.length;i++){
            if(!this.usedChannels[i] && i != SongTrack.getDefaultPercusionChannel()){
                return i;
            }
        }
        return -1;
    }
    
    
}