/*
 * Created on 19-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.herac.tuxguitar.io.gp.GP3InputStream;
import org.herac.tuxguitar.io.gp.GP4InputStream;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGInputStream;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongLoader {
    private static final String TG_EXTENSION = ".TG";
    private static final String GP3_EXTENSION = ".GP3";
    private static final String GP4_EXTENSION = ".GP4";
    
    private String fileName;
    
    public SongLoader(String fileName){
        this.fileName = fileName;
    }
    
    public Song load() throws GPFormatException, IOException{
        Song song = null;
        if(hasExtension(TG_EXTENSION)){
            song = loadTGFile();
        }else if(hasExtension(GP3_EXTENSION)){
            song = loadGP3File();
        }else if(hasExtension(GP4_EXTENSION)){
            song = loadGP4File();
        }
        return song;
    }
    
    
    private boolean hasExtension(String extension) {
        return (this.fileName.toUpperCase().endsWith(extension)) ;
    }    
    
    private Song loadTGFile() throws FileNotFoundException{
        Song song = new TGInputStream(this.fileName).read();
        return song;
    }    
    
    private Song loadGP3File() throws GPFormatException, IOException{
        GP3InputStream is = new GP3InputStream(this.fileName);
        return is.readSong();        
    }
    
    private Song loadGP4File() throws GPFormatException, IOException{
        GP4InputStream is = new GP4InputStream(this.fileName);
        return is.readSong();   
    }    
}
