/*
 * Created on 28-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.bend;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.song.models.BendEffect;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class BendEditor extends Composite{
    public static final int X_SPAN = 30;
    public static final int Y_SPAN = 15;    
    private static final int X_LENGTH = BendEffect.MAX_POSITION_LENGTH + 1;
    private static final int Y_LENGTH = BendEffect.MAX_VALUE_LENGTH + 1;

    private int[] x; 
    private int[] y;
    private int width;
    private int height;    
    private List points;
    
    public BendEditor(Composite parent, int style) {
        super(parent, style);
        this.init();
        
        this.setBackground(new Color(getDisplay(), 255, 255, 255));
        this.addPaintListener(new PaintListener() {
            public void paintControl(PaintEvent e) {
                paintEditor(e.gc);

            }
        });

        this.addMouseListener(new MouseListener() {
            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                checkPoint(e.x,e.y);
                redraw();
            }
        });
    }

    private void init(){
        this.x = new int[X_LENGTH];
        this.y = new int[Y_LENGTH];
        this.width = ((X_SPAN * X_LENGTH) - X_SPAN);
        this.height = ((Y_SPAN * Y_LENGTH) - Y_SPAN);
        this.points = new ArrayList();
        
        for(int i = 0;i < x.length;i++){
            this.x[i] = ((i + 1) * X_SPAN);            
        }
        for(int i = 0;i < y.length;i++){
            this.y[i] = ((i + 1) * Y_SPAN);
        }
                
    }
    
    private void paintEditor(GC gc){        
        for(int i = 0;i < x.length;i++){
            this.setStyleX(gc,i);
            gc.drawLine(this.x[i],Y_SPAN,this.x[i],Y_SPAN + this.height);
        }
        for(int i = 0;i < y.length;i++){
            this.setStyleY(gc,i);
            gc.drawLine(X_SPAN,this.y[i],X_SPAN + this.width,this.y[i]);
        }       
        
        
        Iterator it = null;
        Point prevPoint = null;
        gc.setLineStyle(SWT.LINE_SOLID);
        gc.setLineWidth(2);
        gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_GRAY));        
        it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();            
            if(prevPoint != null){                                
                gc.drawLine(prevPoint.x,prevPoint.y,point.x,point.y);
            }            
            prevPoint = point;
        }        
        
        
        gc.setLineWidth(5);
        gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_BLACK));                                       
        it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();                       

            gc.drawRectangle(point.x - 2,point.y - 2,5,5);           
        }
        gc.setLineWidth(1);
    }


    
    private void setStyleX(GC gc,int i){
        gc.setLineStyle(SWT.LINE_SOLID);
        if(i == 0 || i == (X_LENGTH - 1)){
            gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_BLACK));
        }else{            
            gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_BLUE));
            if((i % 3) > 0){
                gc.setLineStyle(SWT.LINE_DOT);            
            }
        }
    }    
    
    private void setStyleY(GC gc,int i){
        gc.setLineStyle(SWT.LINE_SOLID);
        if(i == 0 || i == (Y_LENGTH - 1)){
            gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_BLACK));
        }else{         
            gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_RED));
        
            if((i % 2) > 0){
                gc.setLineStyle(SWT.LINE_DOT);
                gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_GRAY));
            }else if((i % 4) > 0){
                gc.setLineStyle(SWT.LINE_DOT);         
            }
        }
    }
    
    
    
    private void checkPoint(int x,int y){        
        Point point = new Point(this.getX(x),this.getY(y));
        if(!this.removePoint(point)){
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }
    
    private boolean removePoint(Point point){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point currPoint = (Point)it.next();
            if(currPoint.x == point.x && currPoint.y == point.y){
                this.points.remove(point);
                return true;
            }
        }  
        return false;
    }
    
    private void orderPoints(){
        for(int i = 0;i < this.points.size();i++){
            Point minPoint = null;
            for(int noteIdx = i;noteIdx < this.points.size();noteIdx++){
                Point point = (Point)this.points.get(noteIdx);
                if(minPoint == null || point.x < minPoint.x){
                    minPoint = point;
                }
            }
            this.points.remove(minPoint);
            this.points.add(i,minPoint);
        }
    }    
    
    private void removePointsAtXLine(int x){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();
            if(point.x == x){
                this.points.remove(point);
                break;
            }
        }  
    }     
    
    private void addPoint(Point point){
        this.points.add(point);
    }
    
    private int getX(int pointX){  
        int currPointX = -1;        
        for(int i = 0;i < this.x.length;i++){                    
            if(currPointX < 0){
                currPointX = this.x[i];
            }else{                    
                int distanceX = Math.abs(pointX - currPointX);
                int currDistanceX = Math.abs(pointX - this.x[i]);
                if(currDistanceX < distanceX){
                    currPointX = this.x[i];
                }
            }
            
        }
        return currPointX;
    }     
    
    private int getY(int pointY){  
        int currPointY = -1;        
        for(int i = 0;i < this.y.length;i++){                    
            if(currPointY < 0){
                currPointY = this.y[i];
            }else{                    
                int distanceX = Math.abs(pointY - currPointY);
                int currDistanceX = Math.abs(pointY - this.y[i]);
                if(currDistanceX < distanceX){
                    currPointY = this.y[i];
                }
            }
            
        }
        return currPointY;
    }  
    
    public boolean isEmpty(){
        return this.points.isEmpty();
    }
    
    public void addBendPoints(BendEffect effect){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();            
            addBendPoint(effect,point);
        }         
    }
    
    private void addBendPoint(BendEffect effect,Point point){
        int position = 0;
        int value = 0;
        for(int i=0;i<this.x.length;i++){
            if(point.x == this.x[i]){
                position = i;
            }
        }
        for(int i=0;i<this.y.length;i++){
            if(point.y == this.y[i]){
                value = (this.y.length - i) -1;
            }
        }        
        effect.addPoint(position,value); 
    }
    
    
    public void setBend(BendEffect effect){
        this.points.clear();
        Iterator it = effect.getPoints().iterator();
        while(it.hasNext()){
            BendEffect.BendPoint bendPoint = (BendEffect.BendPoint)it.next();
            this.makePoint(bendPoint);
        }
    }
    
    private void makePoint(BendEffect.BendPoint bendPoint){
        Point point = new Point(0,0);        

        point.x = this.x[bendPoint.getPosition()];
        point.y = this.y[(this.y.length - bendPoint.getValue()) - 1]; 
        
        this.points.add(point);
    }
    
    
    public int getWidth(){
        return this.width;        
    }
    
    public int getHeight(){
        return this.height;
    }
}
