/*
 * Created on 24-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.play.models.midiplayer;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongPlayer implements Player {
    private SongManager songManager;
    private Sequencer sequencer;
    private MeasureStartMetaEventListener controller;
    private boolean running;
    private boolean changeTickPosition;
    private long tickPosition;

    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    /**
     * Retorna el Sequenciador 
     */
    private Sequencer getSequencer() {
        try {
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer();
            }
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            return this.sequencer;
        } catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Inicia el Secuenciador y Sintetizador
     */
    public void init() {
        getSequencer().addMetaEventListener(controller);
    }

    /**
     * Resetea los valores
     */
    public void reset() {
        this.stop();
        this.tickPosition = 1000;
        this.setChangeTickPosition(false);
        this.controller.reset();
    }

    /**
     * Cierra el Secuenciador y Sintetizador
     */
    public void close() {
        setRunning(false);
        getSequencer().close();
    }

    /**
     * Para la reproduccion
     */
    public void stop() {
        Sequencer sequencer = getSequencer();
        if (sequencer != null && sequencer.isRunning()) {
            sequencer.stop();
        }
        this.setRunning(false);
    }

    /**
     * Inicia la reproduccion
     */
    public void play() {
        this.stop();
        this.setRunning(true);

        new Thread(new Runnable() {
            public void run() {
                try {
                    addSecuence();
                    getSequencer().start();
                    getSequencer().setTickPosition(tickPosition - 500);
                    setChangeTickPosition(false);

                    while (getSequencer().isRunning()) {
                        if (isChangeTickPosition()) {
                            getSequencer().setTickPosition(tickPosition - 500);
                            setChangeTickPosition(false);
                        }
                        Thread.sleep(10);
                    }

                } catch (InterruptedException e) {
                    e.printStackTrace();
                } catch (InvalidMidiDataException e) {
                    close();
                    init();
                    e.printStackTrace();
                } finally {
                    reset();
                }

            }
        }).start();
        

    }

    /**
     * Indica la posicion del secuenciador
     */
    public void setTickPosition(long position) {
        this.tickPosition = position;
        this.setChangeTickPosition(true);
    }

    /**
     * Asigna el valor a running
     */
    public void setRunning(boolean running) {
        this.running = running;
    }

    /**
     * Retorna True si esta reproduciendo
     */
    public boolean isRunning() {
        return this.running;
    }

    
    
    /**
     * Retorna True si hay cambios en la posicion
     */    
    private boolean isChangeTickPosition() {
        return changeTickPosition;
    }
    /**
     * Asigna los cambios de la posicion
    */    
    private void setChangeTickPosition(boolean changeTickPosition) {
        this.changeTickPosition = changeTickPosition;
    }
    
    /**
     * Retorna el indice del compas que se esta reproduciendo
     */
    public long getTickPosition() {
        return this.controller.getTickPosition();
    }

    /**
     * Agrega la Secuencia
     */
    public void addSecuence() throws InvalidMidiDataException {
        SongSequence songSequence = new SongSequence(songManager);
        songSequence.createSongSecuence();
        getSequencer().setSequence(songSequence.getSongSecuence());
    }

    
    /**
     * Retorna el Soundbank por defecto
     */
    public Soundbank getDefaultSoundbank() {
        Sequencer sequencer = getSequencer();
        if (sequencer instanceof Synthesizer) {
            Synthesizer synth = (Synthesizer) sequencer;
            return synth.getDefaultSoundbank();
        }
        return null;
    }
}