/*
 * Created on 09-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureTransferable implements Transferable {
    private TablatureEditor tablatureEditor;
    private List measures;

    public MeasureTransferable(TablatureEditor tablatureEditor, long p1, long p2) {
        this.tablatureEditor = tablatureEditor;
        this.measures = new ArrayList();
        this.getTransfer(p1, p2);
    }

    private void getTransfer(long p1, long p2) {
        SongTrackCoords trackCoords = tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        this.measures = trackCoords.copyMeasures(p1, p2);
    }

    public void insertTransfer() throws CannotInsertTransferException {
        List measures = null;
        MeasureCoords measure = tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = tablatureEditor.getTablature().getCaret().getSongCoords();
        SongTrackCoords trackCoords = tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        if (measure == null || songCoords == null || trackCoords == null || this.measures.isEmpty()) {
            throw new CannotInsertTransferException();
        }

        int fromIndex = measure.getMeasureId();
        long nextStart = measure.getMeasure().getStart();

        Iterator it = tablatureEditor.getTablature().getSongCoords().getTrackCoords().iterator();
        while (it.hasNext()) {
            SongTrackCoords currTrackCoords = (SongTrackCoords) it.next();

            if (currTrackCoords.equals(trackCoords)) {
                measures = getCloneMeasures(this.measures);
            } else {
                measures = getEmptyMeasures(this.measures);
            }
            moveStart(measures, nextStart);
            currTrackCoords.insertMeasures(measures, fromIndex);
        }
    }

    private void moveStart(List measures, long nextStart) {
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure) it.next();
            long theMove = nextStart - measure.getStart();
            Iterator notes = measure.getNotes().iterator();
            while (notes.hasNext()) {
                Note note = (Note) notes.next();
                note.setStart(note.getStart() + theMove);
            }
            Iterator silences = measure.getSilences().iterator();
            while (silences.hasNext()) {
                Silence silence = (Silence) silences.next();
                silence.setStart(silence.getStart() + theMove);
            }
            measure.setStart(measure.getStart() + theMove);
            nextStart = measure.getStart() + measure.getLength();
        }

    }

    private List getCloneMeasures(List measures) {
        List cloneMeasures = new ArrayList();

        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure) it.next();
            cloneMeasures.add(measure.clone());
        }
        return cloneMeasures;
    }

    private List getEmptyMeasures(List measures) {
        List emptyMeasures = new ArrayList();

        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure) it.next();
            long start = measure.getStart();
            List notes = new ArrayList();
            List silences = new ArrayList();
            TimeSignature timeSignature = (TimeSignature) measure.getTimeSignature().clone();
            Tempo tempo = (Tempo) measure.getTempo().clone();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            
            emptyMeasures.add(new Measure(start, notes, silences, timeSignature, tempo,repeatStart,nombreOfRepetitions));
        }
        return emptyMeasures;
    }
}