/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SilenceCoords;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RemoveNoteAction extends Action{
    public static final String NAME = "REMOVE_NOTE";
    
    public RemoveNoteAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        if(e instanceof KeyEvent){
            KeyEvent keyEvent = (KeyEvent)e;
            if (keyEvent.keyCode != SWT.DEL && keyEvent.keyCode != SWT.BS){
                return false;
            }            
        }                
        Caret caret = getEditor().getTablature().getCaret();
        if(caret.getSelectedComponent() instanceof SilenceCoords){
            SilenceCoords silenceCoords = (SilenceCoords)caret.getSelectedComponent();
            caret.getMeasureCoords().removeSilence(silenceCoords.getSilence(),true);                     
        }else{
            long start = caret.getSelectedComponent().getStart();
            int string = caret.getSelectedString().getNumber();
            caret.getMeasureCoords().removeComponentsAt(start, string,true);        
        }
                
        updateTablature();  
        return true;
    }
    
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());        
        redraw();
    }    

}
