/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.SongWriter;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.SongPlayer;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongManager {
    private static int MAX_CHANNELS = 15;
    private Song song;
    private Player player = new SongPlayer(this);

    public SongManager() {
        this.newSong();
    }

    public void addTrack(SongTrack songTrack) {
        this.getSong().getTracks().add(songTrack);
    }

    public void setSongName(String string) {
        this.getSong().setName(string);
    }

    public Song getSong() {
        return this.song;
    }

    public void newSong() {
        this.setSong(SongManager.makeNewSong());
    }

    public void save(String string) {
        try {
            new SongWriter(string).write(this.getSong());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (GPFormatException gPFormatException) {
            gPFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void open(String string) throws GPFormatException, IOException {
        SongLoader songLoader = new SongLoader(string);
        Song song = songLoader.load();
        if (song != null) {
            this.setSong(song);
        }
    }

    public void setSong(Song song) {
        this.song = song;
        this.player.reset();
    }

    public void setProperties(String string, String string2, String string3, String string4) {
        this.getSong().setName(string);
        this.getSong().setInterpret(string2);
        this.getSong().setAlbum(string3);
        this.getSong().setAuthor(string4);
    }

    public Player getPlayer() {
        return this.player;
    }

    public SongTrack getTrack(Measure measure) {
        SongTrack songTrack = null;
        Iterator iterator = this.getSong().getTracks().iterator();
        while (iterator.hasNext()) {
            SongTrack songTrack2 = (SongTrack)iterator.next();
            if (!songTrack2.getMeasures().contains(measure)) continue;
            songTrack = songTrack2;
            break;
        }
        return songTrack;
    }

    public static Song makeNewSong() {
        ArrayList<SongTrack> arrayList = new ArrayList<SongTrack>();
        arrayList.add(SongManager.makeNewTrack());
        return new Song(arrayList);
    }

    public static SongTrack makeNewTrack() {
        TimeSignature timeSignature = new TimeSignature(4, new Duration(4));
        Tempo tempo = new Tempo(100);
        List list = SongManager.createDefaultInstrumentStrings();
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        arrayList.add(new Measure(1000L, new ArrayList(), new ArrayList(), timeSignature, tempo, false, 0));
        ArrayList arrayList2 = new ArrayList();
        return new SongTrack(0, 0, arrayList, list);
    }

    public int getFreeChannel(int n, boolean bl) {
        return SongManager.getFreeChannel(this.getSong().getTracks(), n, bl);
    }

    public static int getFreeChannel(List list, int n, boolean bl) {
        if (bl) {
            return SongTrack.getDefaultPercusionChannel();
        }
        int n2 = 0;
        boolean bl2 = false;
        while (!bl2) {
            bl2 = true;
            for (int i = 0; i < list.size(); ++i) {
                SongTrack songTrack = (SongTrack)list.get(i);
                if (songTrack.getChannel() != n2 || songTrack.getInstrument() == n) continue;
                bl2 = false;
            }
            if (!bl2 && ++n2 == SongTrack.getDefaultPercusionChannel()) {
                ++n2;
            }
            if (n2 <= MAX_CHANNELS) continue;
            break;
        }
        return n2;
    }

    public boolean[] getUsedChannels() {
        boolean[] blArray = new boolean[MAX_CHANNELS];
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            blArray[songTrack.getChannel()] = true;
        }
        return blArray;
    }

    public static List createDefaultInstrumentStrings() {
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        arrayList.add(new InstrumentString(1, 64));
        arrayList.add(new InstrumentString(2, 59));
        arrayList.add(new InstrumentString(3, 55));
        arrayList.add(new InstrumentString(4, 50));
        arrayList.add(new InstrumentString(5, 45));
        arrayList.add(new InstrumentString(6, 40));
        return arrayList;
    }

    public static List createPercusionStrings() {
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (int i = 1; i <= 6; ++i) {
            arrayList.add(new InstrumentString(i, 0));
        }
        return arrayList;
    }

    public void calculateMeasureStartWidthRepetitions() {
        Iterator iterator = this.getSong().getTracks().iterator();
        while (iterator.hasNext()) {
            SongTrack songTrack = (SongTrack)iterator.next();
            this.calculateMeasureStartWidthRepetitions(songTrack);
        }
    }

    private void calculateMeasureStartWidthRepetitions(SongTrack songTrack) {
        boolean bl = true;
        long l = 1000L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        Measure measure = null;
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure2 = (Measure)songTrack.getMeasures().get(i);
            if (!bl || measure2.getStart() + measure2.getLength() > l2) {
                measure2.setStartWidthRepetitions(measure2.getStart() + l3);
                this.calculateNoteStartWidthRepetitions(measure2, l3);
            }
            if (measure2.isRepeatStart()) {
                n = i;
                l = measure2.getStart();
                bl = true;
            }
            if (bl && measure2.getNumberOfRepetitions() > 0) {
                if (n2 < measure2.getNumberOfRepetitions()) {
                    l2 = measure2.getStart() + measure2.getLength();
                    l3 += l2 - l;
                    i = n - 1;
                    ++n2;
                } else {
                    l = 0L;
                    n2 = 0;
                    l2 = 0L;
                    bl = false;
                }
            }
            measure = measure2;
        }
    }

    private void calculateNoteStartWidthRepetitions(Measure measure, long l) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note = (Note)measure.getNotes().get(i);
            note.setStartWidthRepetitions(note.getStart() + l);
        }
    }
}

