/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class TGOutputStream {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataOutputStream dataOutputStream;

    public TGOutputStream(FileOutputStream fileOutputStream) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(fileOutputStream);
    }

    public TGOutputStream(String string) throws FileNotFoundException {
        this(new FileOutputStream(new File(string)));
    }

    public void write(Song song) {
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeVersion() {
        this.writeString(TG_VERSION);
    }

    private void writeSong(Song song) {
        this.writeString(song.getName());
        this.writeString(song.getInterpret());
        this.writeString(song.getAlbum());
        this.writeString(song.getAuthor());
        this.writeInt(song.getTracks().size());
        Iterator iterator = song.getTracks().iterator();
        while (iterator.hasNext()) {
            SongTrack songTrack = (SongTrack)iterator.next();
            this.writeTrack(songTrack);
        }
    }

    private void writeTrack(SongTrack songTrack) {
        Object object;
        this.writeInt(songTrack.getChannel());
        this.writeInt(songTrack.getInstrument());
        this.writeInt(songTrack.getMeasures().size());
        Iterator iterator = songTrack.getMeasures().iterator();
        while (iterator.hasNext()) {
            object = (Measure)iterator.next();
            this.writeMeasure((Measure)object);
        }
        this.writeInt(songTrack.getStrings().size());
        object = songTrack.getStrings().iterator();
        while (object.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)object.next();
            this.writeInstrumentString(instrumentString);
        }
    }

    private void writeMeasure(Measure measure) {
        Object object;
        this.writeLong(measure.getStart());
        this.writeInt(measure.getNotes().size());
        Iterator iterator = measure.getNotes().iterator();
        while (iterator.hasNext()) {
            object = (Note)iterator.next();
            this.writeNote((Note)object);
        }
        this.writeInt(measure.getSilences().size());
        object = measure.getSilences().iterator();
        while (object.hasNext()) {
            Silence silence = (Silence)object.next();
            this.writeSilence(silence);
        }
        this.writeTimeSignature(measure.getTimeSignature());
        this.writeTempo(measure.getTempo());
        this.writeBoolean(measure.isRepeatStart());
        this.writeInt(measure.getNumberOfRepetitions());
    }

    private void writeNote(Note note) {
        this.writeInt(note.getValue());
        this.writeLong(note.getStart());
        this.writeDuration(note.getDuration());
        this.writeInt(note.getVelocity());
        this.writeInt(note.getString());
        this.writeBoolean(note.isTiedNote());
        this.writeNoteEffect(note.getEffect());
    }

    private void writeSilence(Silence silence) {
        this.writeLong(silence.getStart());
        this.writeDuration(silence.getDuration());
    }

    private void writeInstrumentString(InstrumentString instrumentString) {
        this.writeInt(instrumentString.getNumber());
        this.writeInt(instrumentString.getValue());
    }

    private void writeTempo(Tempo tempo) {
        this.writeInt(tempo.getValue());
    }

    private void writeTimeSignature(TimeSignature timeSignature) {
        this.writeInt(timeSignature.getNumerator());
        this.writeDuration(timeSignature.getDenominator());
    }

    private void writeDuration(Duration duration) {
        this.writeInt(duration.getValue());
        this.writeBoolean(duration.isDotted());
        this.writeBoolean(duration.isDoubleDotted());
        this.writeTupleto(duration.getTupleto());
    }

    private void writeTupleto(Tupleto tupleto) {
        this.writeInt(tupleto.getEnters());
        this.writeInt(tupleto.getTimes());
    }

    private void writeNoteEffect(NoteEffect noteEffect) {
        this.writeBoolean(noteEffect.isVibrato());
        this.writeBoolean(noteEffect.isBend());
        if (noteEffect.isBend()) {
            this.writeBendEffect(noteEffect.getBend());
        }
        this.writeBoolean(noteEffect.isSlide());
        this.writeBoolean(noteEffect.isHammer());
    }

    private void writeBendEffect(BendEffect bendEffect) {
        this.writeInt(bendEffect.getPoints().size());
        Iterator iterator = bendEffect.getPoints().iterator();
        while (iterator.hasNext()) {
            BendEffect.BendPoint bendPoint = (BendEffect.BendPoint)iterator.next();
            this.writeInt(bendPoint.getPosition());
            this.writeInt(bendPoint.getValue());
        }
    }

    private void writeString(String string) {
        try {
            this.dataOutputStream.write(string.length());
            this.dataOutputStream.writeChars(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeInt(int n) {
        try {
            this.dataOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeLong(long l) {
        try {
            this.dataOutputStream.writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeBoolean(boolean bl) {
        try {
            this.dataOutputStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

