/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class GP3InputStream
extends InputStream {
    private static final String GP3_VERSION = "FICHIER GUITAR PRO v3.00";
    private InputStream inputStream;
    private int offset;

    public GP3InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.offset = 0;
    }

    public GP3InputStream(String string) throws FileNotFoundException {
        this(new FileInputStream(new File(string)));
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public int read() throws IOException {
        ++this.offset;
        return this.inputStream.read();
    }

    public static boolean isSupportedVersion(String string) {
        return string.equals(GP3_VERSION);
    }

    public Song readSong() throws IOException, GPFormatException {
        int n;
        int n2;
        int n3;
        String string = this.readStringByte(30);
        if (!GP3InputStream.isSupportedVersion(string)) {
            throw new GPFormatException("Unsuported Version");
        }
        String string2 = this.readStringIntegerPlusOne();
        String string3 = this.readStringIntegerPlusOne();
        String string4 = this.readStringIntegerPlusOne();
        String string5 = this.readStringIntegerPlusOne();
        String string6 = this.readStringIntegerPlusOne();
        String string7 = this.readStringIntegerPlusOne();
        String string8 = this.readStringIntegerPlusOne();
        String string9 = this.readStringIntegerPlusOne();
        int n4 = this.readInt();
        String string10 = "";
        for (n3 = 0; n3 < n4; ++n3) {
            string10 = string10 + this.readStringIntegerPlusOne();
            string10 = string10 + "\n";
        }
        n3 = this.readBoolean() ? 1 : 0;
        int n5 = this.readInt();
        int n6 = this.readInt();
        ArrayList<Channel> arrayList = new ArrayList<Channel>();
        int[] nArray = new int[64];
        for (int i = 0; i < 64; ++i) {
            arrayList.add(new Channel(i, this.readInt(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte()));
            byte[] byArray = new byte[]{0, 0};
            this.read(byArray);
        }
        TimeSignature timeSignature = new TimeSignature(4, new Duration(4));
        int n7 = this.readInt();
        int n8 = this.readInt();
        ArrayList<Measure> arrayList2 = new ArrayList<Measure>();
        if (n7 > 0) {
            for (int i = 0; i < n7; ++i) {
                Measure measure = this.createMeasure(timeSignature);
                arrayList2.add(measure);
            }
        }
        ArrayList<SongTrack> arrayList3 = new ArrayList<SongTrack>();
        for (int i = 0; i < n8; ++i) {
            arrayList3.add(this.createTrack(arrayList3, arrayList));
        }
        long l = 1000L;
        for (n2 = 0; n2 < n7; ++n2) {
            Measure measure = (Measure)arrayList2.get(n2);
            measure.setStart(l);
            for (n = 0; n < n8; ++n) {
                SongTrack songTrack = (SongTrack)arrayList3.get(n);
                Measure measure2 = (Measure)measure.clone();
                Tempo tempo = new Tempo(n5);
                this.addMeasureComponents(songTrack.getStrings(), measure2, songTrack.getMeasures(), tempo);
                measure2.setTempo(tempo);
                songTrack.getMeasures().add(measure2);
            }
            l += measure.getLength();
        }
        n2 = 0;
        n = 0;
        int n9 = this.read();
        while (n9 != -1) {
            if (n == 0 && ++n2 > 4) {
                n = 1;
            }
            n9 = this.read();
        }
        return new Song(string2, string4, string5, string6, arrayList3);
    }

    private List getPlayedStrings(int n, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if ((n & 1) != 0) {
            arrayList.add(((InstrumentString)list.get(6)).clone());
        }
        if ((n & 2) != 0) {
            arrayList.add(((InstrumentString)list.get(5)).clone());
        }
        if ((n & 4) != 0) {
            arrayList.add(((InstrumentString)list.get(4)).clone());
        }
        if ((n & 8) != 0) {
            arrayList.add(((InstrumentString)list.get(3)).clone());
        }
        if ((n & 0x10) != 0) {
            arrayList.add(((InstrumentString)list.get(2)).clone());
        }
        if ((n & 0x20) != 0) {
            arrayList.add(((InstrumentString)list.get(1)).clone());
        }
        if ((n & 0x40) != 0) {
            arrayList.add(((InstrumentString)list.get(0)).clone());
        }
        return arrayList;
    }

    private Duration parseDuration(byte by) {
        Duration duration = null;
        switch (by) {
            case -2: {
                duration = new Duration(1);
                break;
            }
            case -1: {
                duration = new Duration(2);
                break;
            }
            case 0: {
                duration = new Duration(4);
                break;
            }
            case 1: {
                duration = new Duration(8);
                break;
            }
            case 2: {
                duration = new Duration(16);
                break;
            }
            case 3: {
                duration = new Duration(32);
                break;
            }
            case 4: {
                duration = new Duration(64);
            }
        }
        return duration;
    }

    private int getTiedNoteValue(int n, List list, List list2) {
        Serializable serializable;
        int n2;
        if (!list.isEmpty()) {
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                serializable = (Note)list.get(n2);
                if (((Note)serializable).getString() != n) continue;
                return ((Note)serializable).getValue();
            }
        }
        if (!list2.isEmpty()) {
            for (n2 = list2.size() - 1; n2 >= 0; --n2) {
                serializable = (Measure)list2.get(n2);
                for (int i = ((Measure)serializable).getNotes().size() - 1; i >= 0; --i) {
                    Note note = (Note)((Measure)serializable).getNotes().get(i);
                    if (note.getString() != n) continue;
                    return note.getValue();
                }
            }
        }
        return -1;
    }

    private boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    private byte readByte() throws IOException {
        return (byte)this.read();
    }

    private void readColor() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        this.read();
    }

    private int readInt() throws IOException {
        int n = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.read(byArray);
        n = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        return n;
    }

    private void readMarker() throws IOException {
        String string = this.readStringIntegerPlusOne();
        this.readColor();
    }

    private Measure createMeasure(TimeSignature timeSignature) throws IOException {
        byte by;
        int n = this.readUnsignedByte();
        byte by2 = 0;
        if ((n & 1) != 0) {
            by2 = this.readByte();
        }
        byte by3 = 0;
        if ((n & 2) != 0) {
            by3 = this.readByte();
        }
        boolean bl = (n & 4) != 0;
        byte by4 = 0;
        if ((n & 8) != 0) {
            by4 = this.readByte();
        }
        byte by5 = 0;
        if ((n & 0x10) != 0) {
            by5 = this.readByte();
        }
        if ((n & 0x20) != 0) {
            this.readMarker();
        }
        if ((n & 0x40) != 0) {
            by = this.readByte();
            this.readByte();
        }
        if ((n & 0x80) != 0) {
            // empty if block
        }
        byte by6 = by = (n & 0x80) != 0 ? (byte)1 : 0;
        if (by2 > 0) {
            timeSignature.setNumerator(by2);
        }
        if (by3 > 0) {
            timeSignature.setDenominator(new Duration(by3));
        }
        return new Measure(0L, new ArrayList(), new ArrayList(), (TimeSignature)timeSignature.clone(), new Tempo(120), bl, by4);
    }

    private void addMeasureComponents(List list, Measure measure, List list2, Tempo tempo) throws IOException, GPFormatException {
        long l = measure.getStart();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            l += this.addNotes(l, measure.getNotes(), list, list2, tempo);
        }
    }

    private long addNotes(long l, List list, List list2, List list3, Tempo tempo) throws IOException, GPFormatException {
        int n;
        int n2;
        NoteEffect noteEffect = new NoteEffect();
        int n3 = this.readUnsignedByte();
        if ((n3 & 0x80) != 0) {
            n3 &= 0x3F;
        }
        if ((n3 & 0x40) != 0) {
            n2 = this.readUnsignedByte();
            boolean bl = n2 == 0;
            n = n2 == 2 ? 1 : 0;
        }
        n2 = (n3 & 1) != 0 ? 1 : 0;
        Duration duration = this.parseDuration(this.readByte());
        duration.setDotted(n2 != 0);
        if ((n3 & 0x20) != 0) {
            n = this.readInt();
            switch (n) {
                case 3: {
                    duration.getTupleto().setEnters(3);
                    duration.getTupleto().setTimes(2);
                    break;
                }
                case 5: {
                    duration.getTupleto().setEnters(5);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 6: {
                    duration.getTupleto().setEnters(6);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 7: {
                    duration.getTupleto().setEnters(7);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 9: {
                    duration.getTupleto().setEnters(9);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 10: {
                    duration.getTupleto().setEnters(10);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 11: {
                    duration.getTupleto().setEnters(11);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 12: {
                    duration.getTupleto().setEnters(12);
                    duration.getTupleto().setTimes(8);
                }
            }
        }
        if ((n3 & 2) != 0) {
            this.readChordDiagram();
        }
        if ((n3 & 4) != 0) {
            String string = this.readStringIntegerPlusOne();
        }
        if ((n3 & 8) != 0) {
            this.readBeatEffects(noteEffect);
        }
        if ((n3 & 0x10) != 0) {
            this.readMixChange(tempo);
        }
        int n4 = this.readUnsignedByte();
        List list4 = this.getPlayedStrings(n4, list2);
        for (int i = list4.size() - 1; i >= 0; --i) {
            InstrumentString instrumentString = (InstrumentString)list4.get(i);
            Note note = this.parseNote(l, instrumentString, duration, list, list3, (NoteEffect)noteEffect.clone());
            if (note == null) continue;
            list.add(note);
        }
        return duration.getTime();
    }

    private Note parseNote(long l, InstrumentString instrumentString, Duration duration, List list, List list2, NoteEffect noteEffect) throws IOException {
        int n;
        int n2;
        int n3 = this.readUnsignedByte();
        boolean bl = (n3 & 0x40) != 0;
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 4) != 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if ((n3 & 0x20) != 0) {
            n2 = this.readUnsignedByte();
            bl4 = n2 == 2;
            boolean bl6 = bl5 = n2 == 3;
        }
        if ((n3 & 1) != 0) {
            n2 = this.readByte();
            n = this.readByte();
        }
        if ((n3 & 0x10) != 0) {
            n2 = this.readByte();
        }
        n2 = 0;
        if ((n3 & 0x20) != 0) {
            n2 = this.readByte();
        }
        if ((n3 & 0x80) != 0) {
            n = this.readByte();
            byte by = this.readByte();
        }
        if ((n3 & 8) != 0) {
            this.readNoteEffects(noteEffect, duration);
        }
        n = n2;
        if (n2 >= 0 || bl4) {
            if (bl4) {
                n = this.getTiedNoteValue(instrumentString.getNumber(), list, list2);
            }
            return new Note(n, l, (Duration)duration.clone(), 64, instrumentString.getNumber(), bl4, noteEffect);
        }
        return null;
    }

    private String readStringByte(int n) throws IOException {
        int n2 = this.readUnsignedByte();
        byte[] byArray = n != 0 ? new byte[n] : new byte[n2];
        this.read(byArray);
        String string = new String(byArray, 0, n2);
        return string;
    }

    private String readStringInteger() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.read(byArray);
        String string = new String(byArray);
        return string;
    }

    private String readStringIntegerPlusOne() throws IOException {
        String string;
        int n = this.readInt();
        int n2 = n - 1;
        if (n > 0) {
            int n3 = this.read();
            if (n2 != n3) {
                throw new IOException();
            }
            byte[] byArray = new byte[n2];
            this.read(byArray);
            string = new String(byArray);
        } else {
            int n4 = this.read();
            string = "";
        }
        return string;
    }

    private SongTrack createTrack(List list, List list2) throws IOException {
        int n;
        int n2;
        int n3 = this.readUnsignedByte();
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 4) != 0;
        String string = this.readStringByte(40);
        int n4 = this.readInt();
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>(n4);
        for (n2 = 0; n2 < 7; ++n2) {
            n = this.readInt();
            if (n4 <= n2) continue;
            arrayList.add(new InstrumentString(n2 + 1, n));
        }
        n2 = this.readInt();
        n = this.readInt();
        int n5 = this.readInt();
        int n6 = this.readInt();
        int n7 = this.readInt();
        this.readColor();
        Channel channel = this.parseChannel(list, list2, n);
        return new SongTrack(channel.getChannel(), channel.getInstrument(), new ArrayList(), arrayList);
    }

    private Channel parseChannel(List list, List list2, int n) {
        Channel channel = (Channel)list2.get(n - 1);
        int n2 = channel.getInstrument();
        if (n2 == -1) {
            channel.setInstrument(0);
        }
        channel.setChannel(SongManager.getFreeChannel(list, n2, channel.getChannel() == SongTrack.getDefaultPercusionChannel()));
        return channel;
    }

    private int readUnsignedByte() throws IOException {
        return this.read();
    }

    private void readChordDiagram() throws IOException, GPFormatException {
        int n = this.readUnsignedByte();
        if ((n & 1) == 0) {
            String string = this.readStringIntegerPlusOne();
            int n2 = this.readInt();
            if (n2 != 0) {
                for (int i = 0; i < 6; ++i) {
                    int n3 = this.readInt();
                }
            }
        } else {
            int n4;
            int n5;
            boolean bl = this.readBoolean();
            this.skip(3L);
            int n6 = this.readInt();
            int n7 = this.readInt();
            int n8 = this.readInt();
            int n9 = this.readInt();
            int n10 = this.readUnsignedByte();
            this.skip(3L);
            int n11 = this.readUnsignedByte();
            String string = this.readStringByte(34);
            int n12 = this.readInt();
            for (n5 = 0; n5 < 6; ++n5) {
                n4 = this.readInt();
            }
            for (n5 = 0; n5 < 28; ++n5) {
                n4 = this.readUnsignedByte();
            }
            for (n5 = 0; n5 < 7; ++n5) {
                this.readUnsignedByte();
            }
            n5 = this.readUnsignedByte();
        }
    }

    private void readGraceNote() throws IOException {
        byte[] byArray = new byte[4];
        this.read(byArray);
    }

    private void readBend(NoteEffect noteEffect, Duration duration) throws IOException {
        byte by = this.readByte();
        int n = this.readInt();
        BendEffect bendEffect = new BendEffect();
        int n2 = this.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt();
            int n4 = this.readInt();
            byte by2 = this.readByte();
            bendEffect.addPoint(n3 * 12 / 60, n4 * 8 / 100);
        }
        if (!bendEffect.getPoints().isEmpty()) {
            noteEffect.setBend(bendEffect);
        }
    }

    private void readNoteEffects(NoteEffect noteEffect, Duration duration) throws IOException {
        int n = this.readUnsignedByte();
        if ((n & 1) != 0) {
            this.readBend(noteEffect, duration);
        }
        if ((n & 0x10) != 0) {
            this.readGraceNote();
        }
        if ((n & 4) != 0) {
            noteEffect.setSlide(true);
        }
        if ((n & 8) != 0) {
            // empty if block
        }
        if ((n & 2) != 0) {
            noteEffect.setHammer(true);
        }
    }

    private void readBeatEffects(NoteEffect noteEffect) throws IOException {
        int n;
        int n2 = this.readUnsignedByte();
        if ((n2 & 0x20) != 0) {
            n = this.readUnsignedByte();
            if (n == 0) {
                int n3 = this.readInt();
            } else {
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected value in effect: " + n);
                    }
                }
                int n4 = this.readInt();
            }
        }
        if ((n2 & 0x40) != 0) {
            n = this.readByte();
            n = this.readByte();
        }
        if ((n2 & 1) != 0) {
            noteEffect.setVibrato(true);
        }
        if ((n2 & 2) != 0) {
            noteEffect.setVibrato(true);
        }
        if ((n2 & 4) != 0) {
            // empty if block
        }
        if ((n2 & 8) != 0) {
            // empty if block
        }
        if ((n2 & 0x10) != 0) {
            // empty if block
        }
    }

    private void readMixChange(Tempo tempo) throws IOException {
        int n;
        int n2;
        int[] nArray = new int[8];
        int n3 = 0;
        for (n2 = 0; n2 < 7; ++n2) {
            n = this.readByte();
            if (n2 == 0 || n == -1) continue;
            nArray[n3] = n2;
            ++n3;
        }
        n = this.readInt();
        if (n != -1) {
            tempo.setValue(n);
            nArray[n3] = n2;
            ++n3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.readByte();
        }
    }

    private class Channel {
        private int channel;
        private int instrument;
        private byte volume;
        private byte balance;
        private byte chorus;
        private byte reverb;
        private byte phaser;
        private byte tremolo;

        public Channel(int n, int n2, byte by, byte by2, byte by3, byte by4, byte by5, byte by6) {
            this.channel = n;
            this.instrument = n2;
            this.volume = by;
            this.balance = by2;
            this.chorus = by3;
            this.reverb = by4;
            this.phaser = by5;
            this.tremolo = by6;
        }

        public byte getBalance() {
            return this.balance;
        }

        public void setBalance(byte by) {
            this.balance = by;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int n) {
            this.channel = n;
        }

        public byte getChorus() {
            return this.chorus;
        }

        public void setChorus(byte by) {
            this.chorus = by;
        }

        public int getInstrument() {
            return this.instrument;
        }

        public void setInstrument(int n) {
            this.instrument = n;
        }

        public byte getPhaser() {
            return this.phaser;
        }

        public void setPhaser(byte by) {
            this.phaser = by;
        }

        public byte getReverb() {
            return this.reverb;
        }

        public void setReverb(byte by) {
            this.reverb = by;
        }

        public byte getTremolo() {
            return this.tremolo;
        }

        public void setTremolo(byte by) {
            this.tremolo = by;
        }

        public byte getVolume() {
            return this.volume;
        }

        public void setVolume(byte by) {
            this.volume = by;
        }
    }
}

