/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.PageViewLayout;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.TablaturePaintListener;
import org.herac.tuxguitar.gui.tab.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;

public class Tablature
extends Composite {
    private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;
    private ViewLayout viewLayout;
    private Point origin = new Point(0, 0);

    public Tablature(Shell shell, int n) {
        super((Composite)shell, n);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.addPaintListener(new TablaturePaintListener(this));
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.getHorizontalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar.getSelection();
                int n2 = -n - point.x;
                Rectangle rectangle = Tablature.this.getClientArea();
                Tablature.this.getShell().scroll(n2, 0, 0, 0, rectangle.width, rectangle.height, false);
                point.x = -n;
                Tablature.this.redraw();
            }
        });
        final ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar2.getSelection();
                int n2 = -n - point.y;
                Rectangle rectangle = Tablature.this.getBounds();
                Tablature.this.getShell().scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                point.y = -n;
                Tablature.this.redraw();
            }
        });
    }

    public void init() {
        this.viewLayout = new PageViewLayout(this, this.songManager, false);
        this.songCoords = new SongCoords(this, this.songManager);
        this.caret = new Caret(this, this.songManager, this.songCoords);
    }

    public void updateTablature() {
        this.getViewLayout().updateSong();
    }

    public void initCaret() {
        SongTrackCoords songTrackCoords = (SongTrackCoords)this.songCoords.getTrackCoords().get(0);
        this.caret.update((Measure)songTrackCoords.getTrack().getMeasures().get(0));
    }

    public void paintTablature(GC gC) {
        if (this.songManager.getPlayer().isRunning()) {
            MeasureCoords measureCoords = this.getCaret().getSongTrackCoords().getMeasure(this.songManager.getPlayer().getTickPosition());
            this.getViewLayout().followMeasure(measureCoords, false);
        }
        int n = this.getHorizontalBar().getSelection();
        int n2 = this.getVerticalBar().getSelection();
        this.getViewLayout().paintSong(gC, this.getClientArea(), -n, -n2);
        this.width = this.viewLayout.getWidth();
        this.height = this.viewLayout.getHeight();
        if (this.songManager.getPlayer().isRunning()) {
            gC.drawString("Running position: " + this.songManager.getPlayer().getTickPosition(), 10, 10);
        }
        this.updateScroll();
        if (this.getCaret().hasChanges() && !this.songManager.getPlayer().isRunning()) {
            this.getCaret().setChanges(false);
            this.getViewLayout().followMeasure(this.getCaret().getMeasureCoords(), true);
        }
    }

    public void updateScroll() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getClientArea();
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar.setMaximum(this.width + 22);
        scrollBar2.setMaximum(this.height);
        scrollBar.setThumb(Math.min(rectangle.width, rectangle2.width));
        scrollBar2.setThumb(Math.min(rectangle.height, rectangle2.height));
    }

    public void moveScrollHorizontalTo(MeasureCoords measureCoords, int n, int n2, boolean bl) {
        if (measureCoords != null) {
            int n3 = this.getHorizontalBar().getSelection();
            int n4 = this.getClientArea().width;
            int n5 = measureCoords.getPosX();
            int n6 = measureCoords.getWidth();
            if (n5 <= n3) {
                this.getHorizontalBar().setSelection(n5 - n);
                if (bl) {
                    this.redraw();
                }
            } else if (n5 + n6 >= n3 + n4) {
                this.getHorizontalBar().setSelection(n5 - n4 + n2);
                if (bl) {
                    this.redraw();
                }
            }
        }
    }

    public void moveScrollVerticalTo(MeasureCoords measureCoords, int n, int n2, boolean bl) {
        if (measureCoords != null) {
            int n3 = this.getVerticalBar().getSelection();
            int n4 = this.getClientArea().height;
            int n5 = measureCoords.getPosY();
            int n6 = measureCoords.getHeight();
            if (n5 + n3 <= n3) {
                this.getVerticalBar().setSelection(n3 + n5 - n);
                if (bl) {
                    this.redraw();
                }
            } else if (n5 + n6 + n3 >= n3 + n4) {
                this.getVerticalBar().setSelection(n3 + (n4 - (n4 - (n5 - n6))) - n2);
                if (bl) {
                    this.redraw();
                }
            }
        }
    }

    public void resetScroll() {
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public void changeCursor(int n) {
        this.setCursor(new Cursor((Device)this.getDisplay(), n));
    }

    public ViewLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(ViewLayout viewLayout) {
        this.viewLayout = viewLayout;
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }
}

