/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class SelectInstrumentTrackAction
extends Action {
    public static final String NAME = "SELECT_INSTRUMENT_TRACK";
    private Instrument[] instruments;

    public SelectInstrumentTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        SongTrack songTrack = this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginTop = 20;
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 10;
            shell2.setLayout((Layout)gridLayout);
            shell2.setText(TuxGuitar.getProperty("instrument"));
            Label label = new Label((Composite)shell2, 0);
            label.setText(TuxGuitar.getProperty("instrument.instrument"));
            final Combo combo = new Combo((Composite)shell2, 0);
            Instrument[] instrumentArray = this.getInstruments();
            int n = instrumentArray.length;
            if (n > 128) {
                n = 128;
            }
            for (int i = 0; i < n; ++i) {
                instrumentArray[i].getName();
                combo.add(instrumentArray[i].getName());
            }
            combo.setText(instrumentArray[songTrack.getInstrument()].getName());
            combo.setEnabled(!songTrack.isPercusionTrack());
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            final Button button = new Button((Composite)shell2, 32);
            button.setText(TuxGuitar.getProperty("instrument.percusion-track"));
            button.setLayoutData((Object)gridData);
            button.setSelection(songTrack.isPercusionTrack());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    combo.setEnabled(!button.getSelection());
                }
            });
            Button button2 = new Button((Composite)shell2, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData((Object)new GridData(128));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectInstrumentTrackAction.this.setInstrument(combo.getSelectionIndex(), button.getSelection());
                    shell2.dispose();
                }
            });
            Button button3 = new Button((Composite)shell2, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n2 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n3 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n2, n3);
        }
    }

    private Instrument[] getInstruments() {
        if (this.instruments == null) {
            this.instruments = this.loadInstruments();
        }
        return this.instruments;
    }

    private Instrument[] loadInstruments() {
        Instrument[] instrumentArray = null;
        Soundbank soundbank = this.getEditor().getSongManager().getPlayer().getDefaultSoundbank();
        if (soundbank != null) {
            instrumentArray = soundbank.getInstruments();
        }
        return instrumentArray;
    }

    private void setInstrument(int n, boolean bl) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongTrack songTrack = caret.getSongTrackCoords().getTrack();
        if (bl) {
            songTrack.setChannel(this.getEditor().getSongManager().getFreeChannel(n, bl));
            songTrack.setInstrument(n);
            songTrack.setStrings(SongManager.createPercusionStrings());
        } else {
            if (songTrack.isPercusionTrack()) {
                songTrack.setStrings(SongManager.createDefaultInstrumentStrings());
            }
            songTrack.setChannel(this.getEditor().getSongManager().getFreeChannel(n, bl));
            songTrack.setInstrument(n);
        }
    }
}

