/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

public class ChangeTunningTrackAction
extends Action {
    public static final String NAME = "CHANGE_TUNNING_TRACK";
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[7];
    private int stringCount;

    public ChangeTunningTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        if (songTrackCoords != null) {
            this.stringCount = songTrackCoords.getTrack().getStrings().size();
            this.initTempStirngs(songTrackCoords.getTrack().getStrings());
            final Shell shell2 = new Shell(shell, 67680);
            GridLayout gridLayout = new GridLayout(7, true);
            gridLayout.marginTop = 20;
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            gridLayout.verticalSpacing = 40;
            gridLayout.horizontalSpacing = 0;
            shell2.setLayout((Layout)gridLayout);
            shell2.setText(TuxGuitar.getProperty("tunning"));
            String[] stringArray = this.getAllValueNames();
            for (int i = 0; i < 7; ++i) {
                this.stringSpinners[i] = new TunningSpinner((Composite)shell2, 0);
                this.stringSpinners[i].setTexts(stringArray);
            }
            this.updateTunningSpinner();
            Label label = new Label((Composite)shell2, 0);
            label.setText(TuxGuitar.getProperty("tunning.strings"));
            final Spinner spinner = new Spinner((Composite)shell2, 2048);
            GridData gridData = new GridData(40, 15);
            gridData.horizontalSpan = 4;
            spinner.setLayoutData((Object)gridData);
            spinner.setMinimum(4);
            spinner.setMaximum(7);
            spinner.setSelection(this.stringCount);
            spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeTunningTrackAction.this.stringCount = spinner.getSelection();
                    ChangeTunningTrackAction.this.setDefaultTunning();
                    ChangeTunningTrackAction.this.updateTunningSpinner();
                }
            });
            Button button = new Button((Composite)shell2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)new GridData(128));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeTunningTrackAction.this.changeInstrumentStrings();
                    shell2.dispose();
                }
            });
            Button button2 = new Button((Composite)shell2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
        }
    }

    private void changeInstrumentStrings() {
        int n = 1;
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (int i = this.stringCount - 1; i >= 0; --i) {
            arrayList.add(new InstrumentString(n, this.stringSpinners[i].getSelection()));
            ++n;
        }
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        songTrackCoords.changeInstrumentStrings(arrayList);
        new SyncThread(this.getEditor(), new Runnable(){

            public void run() {
                ChangeTunningTrackAction.this.updateTablature();
                ChangeTunningTrackAction.this.redraw();
            }
        }).start();
    }

    private void updateTunningSpinner() {
        int n = this.tempStrings.size() - 1;
        Iterator iterator = this.tempStrings.iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)iterator.next();
            this.stringSpinners[n].setSelection(instrumentString.getValue());
            this.stringSpinners[n].setVisible(true);
            --n;
        }
        for (int i = this.tempStrings.size(); i < 7; ++i) {
            this.stringSpinners[i].setSelection(0);
            this.stringSpinners[i].setVisible(false);
        }
    }

    private void initTempStirngs(List list) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)list.get(i);
            this.tempStrings.add(instrumentString.clone());
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();
        switch (this.stringCount) {
            case 7: {
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                this.tempStrings.add(new InstrumentString(7, 35));
                break;
            }
            case 6: {
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                break;
            }
            case 5: {
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                this.tempStrings.add(new InstrumentString(5, 23));
                break;
            }
            case 4: {
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
            }
        }
    }

    private String[] getAllValueNames() {
        String[] stringArray = new String[120];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getValueName(i);
        }
        return stringArray;
    }

    private String getValueName(int n) {
        String string = null;
        int n2 = n / 12;
        switch (n -= n2 * 12) {
            case 0: {
                string = "C";
                break;
            }
            case 1: {
                string = "C#";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = "D#";
                break;
            }
            case 4: {
                string = "E";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 6: {
                string = "F#";
                break;
            }
            case 7: {
                string = "G";
                break;
            }
            case 8: {
                string = "G#";
                break;
            }
            case 9: {
                string = "A";
                break;
            }
            case 10: {
                string = "Bb";
                break;
            }
            case 11: {
                string = "B";
            }
        }
        return string + n2;
    }

    private class TunningSpinner
    extends Composite {
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;

        public TunningSpinner(Composite composite, int n) {
            super(composite, n);
            this.setLayout(this.createLayout(2));
            this.init();
        }

        private void init() {
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(30, 22));
            this.buttonComposite = new Composite((Composite)this, 0);
            this.buttonComposite.setLayout(this.createLayout(1));
            this.upButton = new Button(this.buttonComposite, 132);
            this.upButton.setLayoutData((Object)new GridData(15, 15));
            this.downButton = new Button(this.buttonComposite, 1028);
            this.downButton.setLayoutData((Object)new GridData(15, 15));
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;
            this.text.setEditable(false);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ TunningSpinner this$1;
                {
                    this.this$1 = tunningSpinner;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.setSelection(TunningSpinner.access$600(this.this$1) + 1);
                }
            });
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ TunningSpinner this$1;
                {
                    this.this$1 = tunningSpinner;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.setSelection(TunningSpinner.access$600(this.this$1) - 1);
                }
            });
        }

        private Layout createLayout(int n) {
            GridLayout gridLayout = new GridLayout(n, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            return gridLayout;
        }

        public void setTexts(String[] stringArray) {
            this.texts = stringArray;
            this.minSelection = 0;
            this.maxSelection = stringArray.length - 1;
        }

        public int getSelection() {
            return this.selection;
        }

        public void setSelection(int n) {
            if (n >= this.minSelection && n <= this.maxSelection) {
                this.selection = n;
                if (this.texts != null) {
                    this.text.setText(this.texts[n]);
                }
            }
        }

        static /* synthetic */ int access$600(TunningSpinner tunningSpinner) {
            return tunningSpinner.selection;
        }
    }
}

