/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.TimeSignature;

public class ChangeTimeSignatureAction
extends Action {
    public static final String NAME = "CHANGE_TIME_SIGNATURE";

    public ChangeTimeSignatureAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginTop = 20;
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 10;
            shell2.setLayout((Layout)gridLayout);
            shell2.setText(TuxGuitar.getProperty("composition.timesignature"));
            TimeSignature timeSignature = measureCoords.getMeasure().getTimeSignature();
            Label label = new Label((Composite)shell2, 0);
            label.setText(TuxGuitar.getProperty("composition.timesignature.Numerator"));
            final Combo combo = new Combo((Composite)shell2, 0);
            for (int i = 1; i <= 32; ++i) {
                combo.add(Integer.toString(i));
            }
            combo.setText(Integer.toString(timeSignature.getNumerator()));
            Label label2 = new Label((Composite)shell2, 0);
            label2.setText(TuxGuitar.getProperty("composition.timesignature.denominator"));
            final Combo combo2 = new Combo((Composite)shell2, 0);
            for (int i = 1; i <= 32; i *= 2) {
                combo2.add(Integer.toString(i));
            }
            combo2.setText(Integer.toString(timeSignature.getDenominator().getValue()));
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            final Button button = new Button((Composite)shell2, 32);
            button.setText(TuxGuitar.getProperty("composition.timesignature.to-the-end"));
            button.setLayoutData((Object)gridData);
            Button button2 = new Button((Composite)shell2, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData((Object)new GridData(128));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button.getSelection();
                    int n = Integer.parseInt(combo.getText());
                    int n2 = Integer.parseInt(combo2.getText());
                    TimeSignature timeSignature = new TimeSignature(n, new Duration(n2));
                    ChangeTimeSignatureAction.this.setTimeSignature(timeSignature, bl);
                    shell2.dispose();
                }
            });
            Button button3 = new Button((Composite)shell2, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
        }
    }

    private void setTimeSignature(TimeSignature timeSignature, boolean bl) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        songCoords.changeTimeSignature(measureCoords.getMeasure().getStart(), timeSignature, bl);
        this.updateTablature();
        caret.update(caret.getMeasureCoords().getMeasure());
        this.redraw();
    }
}

