/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;

public abstract class Action
implements SelectionListener,
KeyListener,
MouseListener {
    private String name;
    private TablatureEditor tablatureEditor;

    public Action(String string, TablatureEditor tablatureEditor) {
        this.name = string;
        this.tablatureEditor = tablatureEditor;
    }

    public abstract boolean doAction(TypedEvent var1);

    protected void update() {
        TuxGuitar.instance().getItemContainerManager().updateItems();
    }

    private synchronized void process(TypedEvent typedEvent) {
        boolean bl = this.doAction(typedEvent);
        if (bl) {
            this.setLastEvent(typedEvent);
            this.update();
        }
    }

    public String getName() {
        return this.name;
    }

    protected synchronized void redraw() {
        this.tablatureEditor.getTablature().redraw();
    }

    protected synchronized void updateTablature() {
        this.tablatureEditor.getTablature().updateTablature();
    }

    protected void fireUpdate(int n, boolean bl) {
        this.tablatureEditor.getTablature().getViewLayout().fireUpdate(n, bl);
    }

    protected void fireUpdate(int n) {
        this.fireUpdate(n, false);
    }

    protected TablatureEditor getEditor() {
        return this.tablatureEditor;
    }

    protected TypedEvent getLastEvent() {
        return TuxGuitar.instance().getActionContainer().getLastEvent();
    }

    private void setLastEvent(TypedEvent typedEvent) {
        TuxGuitar.instance().getActionContainer().setLastEvent(typedEvent);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.process((TypedEvent)selectionEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.process((TypedEvent)keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.process((TypedEvent)mouseEvent);
    }
}

