/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.gui.language.LanguageManager;
import org.herac.tuxguitar.song.managers.SongManager;

public class TuxGuitar {
    private static TuxGuitar instance;
    private String basePath = new File("").getAbsolutePath() + File.separator;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private LanguageManager languageManager;
    private TablatureEditor tablatureEditor;
    private ActionContainer actionContainer;
    private ItemContainerManager itemContainerManager;
    static /* synthetic */ Class class$org$herac$tuxguitar$gui$TuxGuitar;

    public static void main(String[] stringArray) {
        TuxGuitar.instance().displayGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TuxGuitar instance() {
        if (instance == null) {
            Class clazz = class$org$herac$tuxguitar$gui$TuxGuitar == null ? (class$org$herac$tuxguitar$gui$TuxGuitar = TuxGuitar.class$("org.herac.tuxguitar.gui.TuxGuitar")) : class$org$herac$tuxguitar$gui$TuxGuitar;
            synchronized (clazz) {
                instance = new TuxGuitar();
            }
        }
        return instance;
    }

    private void initLanguage() {
        this.languageManager = new LanguageManager();
        this.languageManager.setLanguage("en");
    }

    public void displayGUI() {
        this.initLanguage();
        this.display = new Display();
        Shell shell = this.getSplashShell(this.display);
        shell.open();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        this.shell.setImage(new Image((Device)this.display, TuxGuitar.getResourcePath(this, "icon.png")));
        this.songManager = new SongManager();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        this.initActions();
        this.initItems();
        this.tablatureEditor.showTablature(this.shell);
        this.shell.setSize(640, 480);
        this.shell.open();
        shell.close();
        shell.dispose();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        this.songManager.getPlayer().close();
        System.exit(0);
    }

    private Shell getSplashShell(Display display) {
        Shell shell = new Shell(display, 262152);
        final Image image = new Image((Device)display, TuxGuitar.getResourcePath(this, "splash.png"));
        int n = image.getBounds().width;
        int n2 = image.getBounds().height;
        int n3 = (display.getBounds().width - display.getBounds().x) / 2 - n / 2;
        int n4 = (display.getBounds().height - display.getBounds().y) / 2 - n2 / 2;
        shell.setBounds(n3, n4, n, n2);
        shell.setImage(new Image((Device)display, TuxGuitar.getResourcePath(this, "icon.png")));
        shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.drawImage(image, 0, 0);
            }
        });
        return shell;
    }

    private void initItems() {
        this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
        this.itemContainerManager.createMenu(this.shell);
        this.itemContainerManager.createToolbar(this.shell);
    }

    private void initActions() {
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }

    public Action getAction(String string) {
        return this.actionContainer.getAction(string);
    }

    public ItemContainerManager getItemContainerManager() {
        return this.itemContainerManager;
    }

    public ActionContainer getActionContainer() {
        return this.actionContainer;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public static String getProperty(String string) {
        return TuxGuitar.instance().languageManager.getProperty(string);
    }

    public static String getResourcePath(Object object, String string) {
        return TuxGuitar.instance().basePath + "files" + File.separator + string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

