/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.tab.widgets.MeasureComponent;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.NoteCoords;
import org.herac.tuxguitar.gui.tab.widgets.SilenceCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.widgets.Tablature;
import org.herac.tuxguitar.gui.tab.widgets.TablatureUtil;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class Caret {
    private Tablature tablature;
    private SongManager songManager;
    private SongCoords songCoords;
    private SongTrackCoords selectedTrack;
    private MeasureCoords selectedMeasure;
    private MeasureComponent selectedComponent;
    private Duration selectedDuration;
    private int posX;
    private int posY;
    private long position;
    private int string;
    private boolean changes;

    public Caret(Tablature tablature, SongManager songManager, SongCoords songCoords) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.songCoords = songCoords;
        this.selectedDuration = new Duration(4);
        this.string = 1;
        this.changes = false;
    }

    private void setSelectedMeasureCoords(MeasureCoords selectedMeasure) {
        if (this.selectedMeasure != null) {
            this.selectedMeasure.setCaret(null);
        }
        this.selectedMeasure = selectedMeasure;
        if (this.selectedMeasure != null) {
            this.selectedMeasure.setCaret(this);
        }
    }

    public synchronized void update(Measure measure) {
        SongTrack track;
        SongTrackCoords trackCoords;
        if (measure != null && (trackCoords = this.songCoords.getTrack(track = this.songManager.getTrack(measure))) != null) {
            MeasureCoords measureCoords = trackCoords.getMeasure(measure);
            MeasureComponent component = null;
            if (this.getSelectedComponent() == null) {
                component = measureCoords.getFirstComponent();
            } else if (this.getSelectedComponent() instanceof NoteCoords) {
                NoteCoords noteCoords = (NoteCoords)this.getSelectedComponent();
                component = measureCoords.getComponent(noteCoords.getStart(), noteCoords.getNote().getString());
            } else {
                component = measureCoords.getComponent(this.getSelectedComponent().getStart());
            }
            if (component == null) {
                component = measureCoords.getFirstComponent();
            }
            this.moveTo(trackCoords, measureCoords, component);
        }
    }

    public void paintCaret(GC gc, int fromX, int fromY) {
        if (this.selectedMeasure != null && this.selectedComponent != null) {
            long start = this.selectedComponent.getStart();
            this.posX = fromX + TablatureUtil.getStartPosition(this.selectedMeasure.getMeasure(), start, this.selectedMeasure.getQuarterSpan()) + 4;
            this.posY = fromY + this.string * 12 - 7;
            gc.drawRectangle(this.posX, this.posY, 13, 15);
        }
    }

    public void setStringNumber(int string) {
        this.string = string;
    }

    public boolean moveRight() {
        if (this.selectedComponent != null) {
            MeasureComponent nextComponent = this.selectedMeasure.getNextComponent(this.selectedComponent);
            if (nextComponent != null) {
                this.selectedComponent = nextComponent;
            } else {
                MeasureCoords nextMeasureCoords = this.selectedTrack.getNextMeasure(this.selectedMeasure);
                if (nextMeasureCoords == null) {
                    return false;
                }
                this.setSelectedMeasureCoords(nextMeasureCoords);
                this.selectedComponent = this.selectedMeasure.getFirstComponent();
            }
            this.updatePosition();
            this.updateDuration();
            this.setChanges(true);
        }
        return true;
    }

    public void moveLeft() {
        if (this.selectedComponent != null) {
            MeasureComponent prevComponent = this.selectedMeasure.getPreviousComponent(this.selectedComponent);
            if (prevComponent != null) {
                this.selectedComponent = prevComponent;
            } else {
                MeasureCoords prevMeasureCoords = this.selectedTrack.getPrevMeasure(this.selectedMeasure);
                if (prevMeasureCoords != null) {
                    this.setSelectedMeasureCoords(prevMeasureCoords);
                    this.selectedComponent = this.selectedMeasure.getLastComponent();
                }
            }
            this.updatePosition();
            this.updateDuration();
            this.setChanges(true);
        }
    }

    private void updateDuration() {
        if (this.selectedComponent != null) {
            boolean hasNotes = false;
            Iterator it = this.getMeasureCoords().getComponentsBeforeEnd(this.getSelectedComponent().getStart()).iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent)it.next();
                if (!(component instanceof NoteCoords)) continue;
                hasNotes = true;
                break;
            }
            if (hasNotes) {
                if (this.selectedComponent instanceof SilenceCoords) {
                    long length = this.selectedComponent.getDuration().getTime();
                    MeasureComponent nextComponent = this.getMeasureCoords().getNextComponent(this.selectedComponent);
                    while (nextComponent != null && nextComponent instanceof SilenceCoords) {
                        length += nextComponent.getDuration().getTime();
                        nextComponent = this.getMeasureCoords().getNextComponent(nextComponent);
                    }
                    if (this.selectedDuration.getTime() > length) {
                        this.selectedDuration = (Duration)this.selectedComponent.getDuration().clone();
                    }
                } else {
                    this.selectedDuration = (Duration)this.selectedComponent.getDuration().clone();
                }
            }
        }
    }

    public void moveUp() {
        this.changeString(-1);
    }

    public void moveDown() {
        this.changeString(1);
    }

    private void changeString(int i) {
        int nextString = this.string + i;
        int trackStrings = this.selectedTrack.getTrack().getStrings().size();
        if (nextString < 1) {
            nextString = trackStrings;
        } else if (nextString > trackStrings) {
            nextString = 1;
        }
        this.string = nextString;
    }

    public long getPosition() {
        return this.position;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public MeasureCoords getMeasureCoords() {
        return this.selectedMeasure;
    }

    public SongTrackCoords getSongTrackCoords() {
        return this.selectedTrack;
    }

    public MeasureComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Duration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(Duration selectedDuration) {
        this.selectedDuration = selectedDuration;
    }

    public InstrumentString getSelectedString() {
        List strings = this.selectedTrack.getTrack().getStrings();
        Iterator it = strings.iterator();
        while (it.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)it.next();
            if (instrumentString.getNumber() != this.string) continue;
            return instrumentString;
        }
        return null;
    }

    public void moveTo(SongTrackCoords selectedTrack, MeasureCoords selectedMeasure, MeasureComponent selectedComponent) {
        this.selectedTrack = selectedTrack;
        this.selectedComponent = selectedComponent;
        this.setSelectedMeasureCoords(selectedMeasure);
        this.updatePosition();
        this.updateDuration();
    }

    public void changeDuration(Duration duration) {
        this.getMeasureCoords().changeDuration(this.getPosition(), duration);
        this.setChanges(true);
    }

    private void updatePosition() {
        this.position = this.getSelectedComponent().getStart();
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }
}

