/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.RepeatToolItems;
import org.herac.tuxguitar.gui.items.tool.TiedNoteToolItems;

public class ItemContainerManager {
    private TablatureEditor tablatureEditor;
    private List items;

    public ItemContainerManager(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
        this.items = new ArrayList();
    }

    public void createToolbar(Shell shell) {
        ToolBar toolBar = new ToolBar((Composite)shell, 0x800000);
        toolBar.setLayout((Layout)new GridLayout());
        FileToolItems fileItems = new FileToolItems(this.tablatureEditor, toolBar);
        CompositionToolItems compositionItems = new CompositionToolItems(this.tablatureEditor, toolBar);
        DurationToolItems durationItems = new DurationToolItems(this.tablatureEditor, toolBar);
        RepeatToolItems repeatItems = new RepeatToolItems(this.tablatureEditor, toolBar);
        TiedNoteToolItems tiedNoteItems = new TiedNoteToolItems(this.tablatureEditor, toolBar);
        PlayerToolItems playerItems = new PlayerToolItems(this.tablatureEditor, toolBar);
        fileItems.showItems();
        ToolItem separator2 = new ToolItem(toolBar, 2);
        durationItems.showItems();
        ToolItem separator3 = new ToolItem(toolBar, 2);
        playerItems.showItems();
        ToolItem separator4 = new ToolItem(toolBar, 2);
        compositionItems.showItems();
        repeatItems.showItems();
        tiedNoteItems.showItems();
        this.items.add(fileItems);
        this.items.add(compositionItems);
        this.items.add(durationItems);
        this.items.add(repeatItems);
        this.items.add(tiedNoteItems);
        this.items.add(playerItems);
    }

    public void createMenu(Shell shell) {
        Menu menuBar = new Menu((Decorations)shell, 2);
        FileMenuItem fileItem = new FileMenuItem(shell, menuBar, 64, this.tablatureEditor);
        CompositionMenuItem compositionItem = new CompositionMenuItem(shell, menuBar, 64, this.tablatureEditor);
        TrackMenuItem trackItem = new TrackMenuItem(shell, menuBar, 64, this.tablatureEditor);
        MeasureMenuItem measureItem = new MeasureMenuItem(shell, menuBar, 64, this.tablatureEditor);
        DurationMenuItem durationItem = new DurationMenuItem(shell, menuBar, 64, this.tablatureEditor);
        PlayMenuItem playItem = new PlayMenuItem(shell, menuBar, 64, this.tablatureEditor);
        HelpMenuItem helpItem = new HelpMenuItem(shell, menuBar, 64);
        fileItem.showItems();
        compositionItem.showItems();
        helpItem.showItems();
        trackItem.showItems();
        measureItem.showItems();
        durationItem.showItems();
        playItem.showItems();
        shell.setMenuBar(menuBar);
        this.items.add(fileItem);
        this.items.add(compositionItem);
        this.items.add(trackItem);
        this.items.add(measureItem);
        this.items.add(durationItem);
        this.items.add(playItem);
        this.items.add(helpItem);
    }

    public void updateItems() {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            ItemContainer item = (ItemContainer)it.next();
            item.update();
        }
    }
}

