/*
 * Created on 24-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.play.models.midiplayer;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongPlayer implements Player {
    private SongManager songManager;
    private Synthesizer synth;
    private Sequencer sequencer;
    private MeasureStartMetaEventListener controller;
    private boolean running;
    private boolean changeTickPosition;
    private long tickPosition;
    
    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    /**
     * Inicia el Secuenciador y Sintetizador
     */
    public void init() {
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();

            sequencer = MidiSystem.getSequencer();
            sequencer.open();
            sequencer.addMetaEventListener(controller);            
        } catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void reset(){
        if(this.sequencer.isOpen()){
            this.stop();
        }
        this.running = false;
        this.tickPosition = 1000;
        this.changeTickPosition = false;  
        this.controller.reset();
    }
    
    /**
     * Cierra el Secuenciador y Sintetizador
     */
    public void close() {
        this.running = false;
        sequencer.close();
        synth.close();
    }

    /**
     * Para la reproduccion
     */
    public void stop() {
        if (sequencer != null && sequencer.isRunning()) {
            this.running = false;
            sequencer.stop();
        }
    }

    /**
     * Crea la Secuencia
     */
    public void play() {
        try {
            this.running = true;
            this.createSecuence();            
            this.sequencer.start();
            this.sequencer.setTickPosition(this.tickPosition - 500);
            this.changeTickPosition = false;
            
            while (sequencer.isRunning()) {
                if(this.changeTickPosition){
                    this.sequencer.setTickPosition(this.tickPosition - 500);
                    this.changeTickPosition = false;
                }
                Thread.sleep(10);
            }
            reset();
            
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /**
     * Indica la posicion del secuenciador
     */
    public void setTickPosition(long position) {
        this.tickPosition = position;
        this.changeTickPosition = true;          
    }

    /**
     * Retorna True si esta reproduciendo
     */
    public boolean isRunning() {
        return this.running;
    }

    /**
     * Retorna el indice del compas que se esta reproduciendo
     */
    public long getTickPosition() {
        return this.controller.getTickPosition();
    }

    /**
     * Crea la Secuencia
     */
    public void createSecuence() {
        SongSequence songSequence = new SongSequence(songManager.getSong());
        songSequence.createSongSecuence();
        try {            
            sequencer.setSequence(songSequence.getSongSecuence());
        } catch (InvalidMidiDataException e) {
            sequencer.stop();
            sequencer.close();
            init();
            
            e.printStackTrace();
        }
    }

}