/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeNoteAction extends Action {
    public static final String NAME = "CHANGE_NOTE";

    public ChangeNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        if (e instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent) e;          
            if (isNumber(keyEvent.character)) {
                int value = Integer.parseInt(Character.toString(keyEvent.character));                
                
                int lastAdded = -1;
                TypedEvent lastEvent = getLastEvent();
                if (lastEvent instanceof KeyEvent) {
                    KeyEvent lastKeyEvent = (KeyEvent)lastEvent;
                    if (isNumber(lastKeyEvent.character)) {
                        lastAdded = Integer.parseInt(Character.toString(lastKeyEvent.character));
                    }
                }
                
                
                boolean isPercusionTrack = getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().isPercusionTrack();
                if (((isPercusionTrack) || (lastAdded == 1 || lastAdded == 2)) && lastAdded >= 0) {
                    value = Integer.parseInt(lastAdded + "" + value);
                }
                addNote(value);
                fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
                redraw();
                //updateTablature();            
                return true;
            }            
        }
        return false;
    }

    private boolean isNumber(char c){
        return (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9');
    }
    
    private void addNote(int value) {
        Caret caret = getEditor().getTablature().getCaret();        
        Duration duration = (Duration)caret.getDuration().clone();
        InstrumentString string = new InstrumentString(caret.getSelectedString().getNumber(), caret.getSelectedString().getValue());
        //Note note = new Note(value + string.getValue(), caret.getPosition(), duration, 64, string,false);
        Note note = new Note(value, caret.getPosition(), duration, 64, string.getNumber(),false);
        caret.getMeasureCoords().addNote(note);
    }
    
    /*
    protected void updateTablature() {
        getEditor().getTablature().getSongCoords().fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        redraw();
    }*/

}