/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.mouse;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.MeasureComponent;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SelectComponentAction extends Action {
    public static final String NAME = "SELECT_COMPONENT";

    public SelectComponentAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent) e;

            SongTrackCoords trackCoords = getTrackCoords(mouseEvent.y);
            if (trackCoords != null) {
                MeasureCoords measureCoords = getMeasureCoords(trackCoords, mouseEvent.x);
                if (measureCoords != null) {
                    MeasureComponent measureComponent = getMeasureComponent(measureCoords, mouseEvent.x);
                    InstrumentString instrumentString = getMeasureString(measureCoords, mouseEvent.y);
                    if (measureComponent != null) {
                        getEditor().getTablature().getCaret().moveTo(trackCoords, measureCoords, measureComponent);
                        if (instrumentString != null) {
                            getEditor().getTablature().getCaret().setStringNumber(instrumentString.getNumber());
                        }
                        //marco el punto de inicio para el reproductor
                        getEditor().getTablature().getSongManager().getPlayer().setTickPosition(
                                measureCoords.getMeasure().getStartWidthRepetitions());

                        redraw();
                    }
                }

            }
            return true;
        }
        return false;
    }

    private SongTrackCoords getTrackCoords(int y) {
        return getEditor().getTablature().getSongCoords().getTrackAt(y, -getEditor().getTablature().getVerticalBar().getSelection());
    }

    private MeasureCoords getMeasureCoords(SongTrackCoords trackCoords, int x) {
        return trackCoords.getMeasureAt(x, -getEditor().getTablature().getHorizontalBar().getSelection());
    }

    private MeasureComponent getMeasureComponent(MeasureCoords measureCoords, int x) {
        return measureCoords.getComponentAt(x);
    }

    private InstrumentString getMeasureString(MeasureCoords measureCoords, int y) {
        return measureCoords.getStringAt(y);
    }


}