/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.song.models.Duration;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DecrementDurationAction extends Action{
    public static final String NAME = "DECREMENT_DURATION";    
    
    public DecrementDurationAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        if(e instanceof KeyEvent){
            KeyEvent keyEvent = (KeyEvent)e;
            if (keyEvent.character != '-'){
                return false;
            }            
        }          
        Duration duration = getEditor().getTablature().getCaret().getDuration();
        if(duration.getValue() > Duration.WHOLE){
            this.changeDuration(duration.getValue() / 2);                
            this.updateTablature();
        }      
        return true;
    }
    
    private void changeDuration(int value) {
        Caret caret = getEditor().getTablature().getCaret();      
        caret.getDuration().setValue(value);
        caret.changeDuration((Duration)caret.getDuration().clone());      
    }    
    
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());        
        redraw();
    }   

}
