/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CloseRepeatAction extends Action{
    public static final String NAME = "CLOSE_REPEAT";
    
    public CloseRepeatAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        MeasureCoords measureCoords = getEditor().getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = getEditor().getTablature().getCaret().getSongCoords();        
        showCloseRepeatDialog(getEditor().getTablature().getShell(), measureCoords, songCoords);
        return true;
    }

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        redraw();
    }        
    
    public void showCloseRepeatDialog(Shell shell, final MeasureCoords measureCoords, final SongCoords songCoords) {
        if (measureCoords != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 20;
            layout.horizontalSpacing = 10;  
            dialog.setLayout(layout);
            
            int currentNumberOfRepetitions = measureCoords.getMeasure().getNumberOfRepetitions();
            if (currentNumberOfRepetitions < 1) {
                currentNumberOfRepetitions = 1;
            }

            Label numberOfRepetitionsLabel = new Label(dialog, SWT.NULL);
            numberOfRepetitionsLabel.setText("Number of Repetitions:");

            final Text numberOfRepetitions = new Text(dialog, SWT.BORDER);
            numberOfRepetitions.setLayoutData(new GridData(50,10));
            numberOfRepetitions.setText(Integer.toString(currentNumberOfRepetitions));     
            
            final Button buttonOK = new Button(dialog, SWT.PUSH);            
            buttonOK.setText("Ok");
            buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    closeRepeat(measureCoords, songCoords, Integer.parseInt(numberOfRepetitions.getText()));

                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(dialog, SWT.PUSH);            
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);

        }

    }

    private void closeRepeat(MeasureCoords measureCoords, SongCoords songCoords, int numberOfRepetitions) {
        numberOfRepetitions = Math.abs(numberOfRepetitions);
        songCoords.changeCloseRepeat(measureCoords.getMeasure().getStart(), numberOfRepetitions);
        updateTablature();
    }    

}
