/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import org.herac.tuxguitar.song.models.Tupleto;

public class Duration
implements Serializable {
    public static final long QUARTER_TIME = 1000L;
    public static final int WHOLE = 1;
    public static final int HALF = 2;
    public static final int QUARTER = 4;
    public static final int EIGHTH = 8;
    public static final int SIXTEENTH = 16;
    public static final int THIRTY_SECOND = 32;
    public static final int SIXTY_FOURTH = 64;
    public static final Tupleto NO_TUPLETO = new Tupleto(1, 1);
    private int value;
    private boolean dotted;
    private Tupleto tupleto;

    public Duration(int value, boolean dotted, Tupleto tupleto) {
        this.value = value;
        this.dotted = dotted;
        this.tupleto = tupleto;
    }

    public Duration(int value) {
        this(value, false, new Tupleto(1, 1));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean dotted) {
        this.dotted = dotted;
    }

    public Tupleto getTupleto() {
        return this.tupleto;
    }

    public long getTime() {
        long time = 0L;
        switch (this.value) {
            case 1: {
                time = 4000L;
                break;
            }
            case 2: {
                time = 2000L;
                break;
            }
            case 4: {
                time = 1000L;
                break;
            }
            case 8: {
                time = 500L;
                break;
            }
            case 16: {
                time = 250L;
                break;
            }
            case 32: {
                time = 125L;
                break;
            }
            case 64: {
                time = 62L;
            }
        }
        if (this.dotted) {
            time += time / 2L;
        }
        return this.tupleto.convertTime(time);
    }

    public Object clone() {
        return new Duration(this.value, this.dotted, (Tupleto)this.tupleto.clone());
    }
}

