/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.widgets.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongTrackCoords {
    public static final int DEFAULT_HORIZONTAL_SPAN = 20;
    public static final int DEFAULT_STRING_SPAN = 12;
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    private int posX;
    private int posY;
    private int width;
    private int height;

    public SongTrackCoords(Tablature tablature, SongManager songManager, SongTrack track) {
        this.tablature = tablature;
        this.track = track;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.posX = 20;
    }

    public void createMeasures() {
        this.measuresCoords.clear();
        int measureIdx = 0;
        while (measureIdx < this.track.getMeasures().size()) {
            Measure measure = (Measure)this.track.getMeasures().get(measureIdx);
            MeasureCoords measureCoords = new MeasureCoords(measureIdx, this.songManager, this.tablature, measure, this);
            measureCoords.create();
            this.measuresCoords.add(measureCoords);
            if (this.tablature.getSongCoords().getQuarterSpans().size() > measureIdx) {
                this.tablature.getSongCoords().getQuarterSpan(measureIdx).setQuarterSpan(measureCoords.getQuarterSpan());
            } else {
                this.tablature.getSongCoords().addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
            }
            ++measureIdx;
        }
    }

    public void updateMeasures() {
        this.width = 0;
        int maxHeight = 0;
        int measureIdx = 0;
        while (measureIdx < this.getMeasuresCoords().size()) {
            MeasureCoords measureCoords = (MeasureCoords)this.getMeasuresCoords().get(measureIdx);
            measureCoords.setQuarterSpan(this.tablature.getSongCoords().getQuarterSpan(measureIdx).getQuarterSpan());
            measureCoords.setPosX(this.width);
            measureCoords.setPosY(0);
            measureCoords.update();
            this.width += measureCoords.getWidth();
            if (measureCoords.getHeight() > maxHeight) {
                maxHeight = measureCoords.getHeight();
            }
            ++measureIdx;
        }
        this.height = maxHeight;
    }

    public void fireChanges(int measureId, QuarterSpanHelper quarterSpan, boolean isNew) {
        MeasureCoords measureCoords = null;
        if (isNew) {
            Measure measure = (Measure)this.track.getMeasures().get(measureId);
            measureCoords = new MeasureCoords(measureId, this.songManager, this.tablature, measure, this);
            this.getMeasuresCoords().add(measureCoords);
        } else {
            measureCoords = (MeasureCoords)this.getMeasuresCoords().get(measureId);
        }
        measureCoords.create();
        quarterSpan.setQuarterSpan(measureCoords.getQuarterSpan());
    }

    public void fireUpdate(int measureId, QuarterSpanHelper quarterSpan) {
        MeasureCoords measureCoords = (MeasureCoords)this.getMeasuresCoords().get(measureId);
        measureCoords.setQuarterSpan(quarterSpan.getQuarterSpan());
        int oldWidth = measureCoords.getWidth();
        this.width -= oldWidth;
        measureCoords.update();
        this.width += measureCoords.getWidth();
    }

    private void checkPosX(int fromX) {
        this.posX = 20;
        if (fromX <= -this.posX) {
            this.posX = 0;
        }
    }

    public void paintTrack(GC gc, int fromX, int fromY, Rectangle clientArea) {
        this.checkPosX(fromX);
        this.paintMeasures(gc, fromX, fromY, clientArea);
        this.paintStrings(gc, fromY, clientArea);
    }

    private void paintMeasures(GC gc, int fromX, int fromY, Rectangle clientArea) {
        this.posY = fromY;
        int posX = this.posX;
        int measureIdx = 0;
        while (measureIdx < this.measuresCoords.size()) {
            MeasureCoords measureCoords = (MeasureCoords)this.measuresCoords.get(measureIdx);
            measureCoords.setPosX(posX);
            measureCoords.setPosY(0);
            if (posX + fromX > clientArea.x - 1500 && posX + fromX < clientArea.x + clientArea.width + 100) {
                measureCoords.paintMeasure(gc, posX + fromX, this.posY, clientArea);
            }
            posX += measureCoords.getWidth();
            ++measureIdx;
        }
    }

    private void paintStrings(GC gc, int fromY, Rectangle clientArea) {
        int posX = this.posX + clientArea.x;
        Iterator it = this.getTrack().getStrings().iterator();
        while (it.hasNext()) {
            InstrumentString string = (InstrumentString)it.next();
            int stringSpan = string.getNumber() * 12;
            gc.drawLine(posX, fromY + stringSpan, posX + clientArea.width, fromY + stringSpan);
        }
    }

    public List getMeasuresCoords() {
        return this.measuresCoords;
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public MeasureCoords getFirstMeasure() {
        MeasureCoords firstMeasure = null;
        int measureIdx = 0;
        while (measureIdx < this.measuresCoords.size()) {
            MeasureCoords currMeasure = (MeasureCoords)this.measuresCoords.get(measureIdx);
            if (firstMeasure == null || currMeasure.getMeasure().getStart() < firstMeasure.getMeasure().getStart()) {
                firstMeasure = currMeasure;
            }
            ++measureIdx;
        }
        return firstMeasure;
    }

    public MeasureCoords getLastMeasure() {
        int lastIndex = this.measuresCoords.size() - 1;
        return (MeasureCoords)this.measuresCoords.get(lastIndex);
    }

    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords) {
        int prevIndex = measureCoords.getMeasureId() - 1;
        if (prevIndex >= 0) {
            return (MeasureCoords)this.measuresCoords.get(prevIndex);
        }
        return null;
    }

    public MeasureCoords getNextMeasure(MeasureCoords measureCoords) {
        int nextIndex = measureCoords.getMeasureId() + 1;
        if (nextIndex < this.measuresCoords.size()) {
            return (MeasureCoords)this.measuresCoords.get(nextIndex);
        }
        return null;
    }

    public MeasureCoords getMeasure(long start) {
        Object measureCoords = null;
        int measureIdx = 0;
        while (measureIdx < this.measuresCoords.size()) {
            MeasureCoords measure = (MeasureCoords)this.measuresCoords.get(measureIdx);
            long measureStart = measure.getMeasure().getStart();
            long measureLength = measure.getMeasure().getLength();
            if (start >= measureStart && start < measureStart + measureLength) {
                return measure;
            }
            ++measureIdx;
        }
        return null;
    }

    public MeasureCoords getMeasure(Measure measure) {
        MeasureCoords measureCoords = null;
        int measureIdx = 0;
        while (measureIdx < this.measuresCoords.size()) {
            MeasureCoords currMeasure = (MeasureCoords)this.measuresCoords.get(measureIdx);
            if (currMeasure.getMeasure().equals(measure)) {
                measureCoords = currMeasure;
                break;
            }
            ++measureIdx;
        }
        return measureCoords;
    }

    public List getMeasuresBeforeEnd(long fromStart) {
        ArrayList<MeasureCoords> measures = new ArrayList<MeasureCoords>();
        Iterator it = this.measuresCoords.iterator();
        while (it.hasNext()) {
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            if (currMeasure.getMeasure().getStart() < fromStart) continue;
            measures.add(currMeasure);
        }
        return measures;
    }

    public List getMeasuresBetween(long p1, long p2) {
        ArrayList<MeasureCoords> measures = new ArrayList<MeasureCoords>();
        Iterator it = this.measuresCoords.iterator();
        while (it.hasNext()) {
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            long start = currMeasure.getMeasure().getStart();
            if (start < p1 || start > p2) continue;
            measures.add(currMeasure);
        }
        return measures;
    }

    public MeasureCoords getMeasureAt(int x, int hScroll) {
        MeasureCoords measureCoords = null;
        long posX = this.posX + hScroll;
        Iterator it = this.measuresCoords.iterator();
        while (it.hasNext()) {
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            long width = currMeasure.getWidth();
            if ((long)x >= posX && (long)x <= posX + width) {
                measureCoords = currMeasure;
                break;
            }
            posX += width;
        }
        return measureCoords;
    }

    public void addNewMeasureBeforeEnd() {
        this.addNewMeasureAfter(this.getLastMeasure().getMeasure());
    }

    public void addNewMeasureAfter(Measure measure) {
        TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
        Tempo tempo = (Tempo)measure.getTempo().clone();
        long start = measure.getStart() + measure.getLength();
        boolean repeatStart = false;
        int nombreOfRepetitions = 0;
        this.addMeasure(new Measure(start, new ArrayList(), new ArrayList(), timeSignature, tempo, repeatStart, nombreOfRepetitions));
    }

    public List copyMeasures(long p1, long p2) {
        ArrayList<Object> measures = new ArrayList<Object>();
        Iterator it = this.getMeasuresBetween(p1, p2).iterator();
        while (it.hasNext()) {
            MeasureCoords measureCoords = (MeasureCoords)it.next();
            measures.add(measureCoords.getMeasure().clone());
        }
        return measures;
    }

    public void insertMeasures(List measures, int fromIndex) {
        long start = -1L;
        long end = 0L;
        Iterator it = null;
        if (!measures.isEmpty()) {
            Object measure;
            start = ((Measure)measures.get(0)).getStart();
            end = ((Measure)measures.get(measures.size() - 1)).getStart() + ((Measure)measures.get(measures.size() - 1)).getLength();
            it = this.getMeasuresBeforeEnd(start).iterator();
            while (it.hasNext()) {
                measure = (MeasureCoords)it.next();
                this.moveMeasure((MeasureCoords)measure, end - start);
            }
            it = measures.iterator();
            while (it.hasNext()) {
                measure = (Measure)it.next();
                this.addMeasure(fromIndex, (Measure)measure);
                ++fromIndex;
            }
        }
    }

    public void addMeasure(Measure measure) {
        this.track.getMeasures().add(measure);
    }

    public void addMeasure(int index, Measure measure) {
        this.track.getMeasures().add(index, measure);
    }

    public void removeMeasure(long start) {
        this.removeMeasure(this.getMeasure(start));
    }

    public void removeMeasure(MeasureCoords measure) {
        long start = measure.getMeasure().getStart();
        long length = measure.getMeasure().getLength();
        List nextMeasures = this.getMeasuresBeforeEnd(start + 1L);
        Iterator it = nextMeasures.iterator();
        while (it.hasNext()) {
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            this.moveMeasure(currMeasure, -length);
        }
        this.track.getMeasures().remove(measure.getMeasure());
    }

    public void moveMeasure(MeasureCoords measure, long theMove) {
        measure.moveAllComponents(theMove);
        measure.getMeasure().setStart(measure.getMeasure().getStart() + theMove);
    }

    public void changeTimeSignature(long start, TimeSignature timeSignature, boolean toEnd) {
        this.changeTimeSignature(this.getMeasure(start), timeSignature, toEnd);
    }

    public void changeTimeSignature(MeasureCoords measure, TimeSignature timeSignature, boolean toEnd) {
        measure.getMeasure().setTimeSignature((TimeSignature)timeSignature.clone());
        long nextStart = measure.getMeasure().getStart() + measure.getMeasure().getLength();
        List measures = this.getMeasuresBeforeEnd(measure.getMeasure().getStart() + 1L);
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            MeasureCoords nextMeasure = (MeasureCoords)it.next();
            long theMove = nextStart - nextMeasure.getMeasure().getStart();
            this.moveMeasure(nextMeasure, theMove);
            if (toEnd) {
                nextMeasure.getMeasure().setTimeSignature((TimeSignature)timeSignature.clone());
            }
            nextStart = nextMeasure.getMeasure().getStart() + nextMeasure.getMeasure().getLength();
        }
    }

    public void changeTempo(long start, Tempo tempo, boolean toEnd) {
        this.changeTempo(this.getMeasure(start), tempo, toEnd);
    }

    public void changeTempo(MeasureCoords measure, Tempo tempo, boolean toEnd) {
        measure.getMeasure().setTempo((Tempo)tempo.clone());
        if (toEnd) {
            List measures = this.getMeasuresBeforeEnd(measure.getMeasure().getStart() + 1L);
            Iterator it = measures.iterator();
            while (it.hasNext()) {
                MeasureCoords nextMeasure = (MeasureCoords)it.next();
                nextMeasure.getMeasure().setTempo((Tempo)tempo.clone());
            }
        }
    }

    public void changeOpenRepeat(long start) {
        Measure measure;
        measure.setRepeatStart(!(measure = this.getMeasure(start).getMeasure()).isRepeatStart());
    }

    public void changeCloseRepeat(long start, int numberOfRepetitions) {
        Measure measure = this.getMeasure(start).getMeasure();
        measure.setNumberOfRepetitions(numberOfRepetitions);
    }

    public void changeInstrumentStrings(List strings) {
        if (strings.size() < this.getTrack().getStrings().size()) {
            this.removeNotesAfterString(strings.size());
        }
        this.getTrack().setStrings(strings);
    }

    public void removeNotesAfterString(int string) {
        Iterator it = this.getMeasuresCoords().iterator();
        while (it.hasNext()) {
            MeasureCoords nextMeasure = (MeasureCoords)it.next();
            nextMeasure.removeNotesAfterString(string);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

