/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.song.models.Duration;

public class DurationToolItems
implements ItemContainer {
    public static final String NAME = "DURATION_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem[] durationItems;
    private ToolItem dotted;
    private ToolItem tupleto;

    public DurationToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
        this.durationItems = new ToolItem[7];
    }

    public void showItems() {
        this.durationItems[0] = new ToolItem(this.toolBar, 16);
        this.durationItems[0].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "1.png")));
        this.durationItems[0].setToolTipText("Redonda");
        this.durationItems[0].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_WHOLE_DURATION"));
        this.durationItems[1] = new ToolItem(this.toolBar, 16);
        this.durationItems[1].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "2.png")));
        this.durationItems[1].setToolTipText("Blanca");
        this.durationItems[1].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_HALF_DURATION"));
        this.durationItems[2] = new ToolItem(this.toolBar, 16);
        this.durationItems[2].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "4.png")));
        this.durationItems[2].setToolTipText("Negra");
        this.durationItems[2].setSelection(true);
        this.durationItems[2].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_QUARTER_DURATION"));
        this.durationItems[3] = new ToolItem(this.toolBar, 16);
        this.durationItems[3].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "8.png")));
        this.durationItems[3].setToolTipText("Corchea");
        this.durationItems[3].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_EIGHTH_DURATION"));
        this.durationItems[4] = new ToolItem(this.toolBar, 16);
        this.durationItems[4].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "16.png")));
        this.durationItems[4].setToolTipText("Semi-Corchea");
        this.durationItems[4].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_SIXTEENTH_DURATION"));
        this.durationItems[5] = new ToolItem(this.toolBar, 16);
        this.durationItems[5].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "32.png")));
        this.durationItems[5].setToolTipText("Fusa");
        this.durationItems[5].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_THIRTY_SECOND_DURATION"));
        this.durationItems[6] = new ToolItem(this.toolBar, 16);
        this.durationItems[6].setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "64.png")));
        this.durationItems[6].setToolTipText("Semi-Fusa");
        this.durationItems[6].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_SIXTY_FOURTH_DURATION"));
        ToolItem separator = new ToolItem(this.toolBar, 2);
        this.dotted = new ToolItem(this.toolBar, 32);
        this.dotted.setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "dotted.png")));
        this.dotted.setToolTipText("Puntillo");
        this.dotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_DOTTED_DURATION"));
        this.tupleto = new ToolItem(this.toolBar, 32);
        this.tupleto.setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "tupleto.png")));
        this.tupleto.setToolTipText("Tupleto");
        this.tupleto.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
    }

    public void update() {
        Duration duration = this.tablatureEditor.getTablature().getCaret().getDuration();
        int i = 0;
        while (i < this.durationItems.length) {
            this.durationItems[i].setSelection(false);
            ++i;
        }
        int index = 0;
        int value = duration.getValue();
        while (value > 1) {
            value /= 2;
            ++index;
        }
        this.durationItems[index].setSelection(true);
        this.dotted.setSelection(duration.isDotted());
        this.tupleto.setSelection(!duration.getTupleto().isEqual(Duration.NO_TUPLETO));
    }
}

