/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;

public class MeasureMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem measureMenuItem;
    private Menu menu;
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addMeasure;
    private MenuItem removeMeasure;
    private MenuItem copyMeasure;
    private MenuItem pasteMeasure;

    public MeasureMenuItem(Shell shell, Menu parent, int style, TablatureEditor tablatureEditor) {
        this.measureMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.first = new MenuItem(this.menu, 8);
        this.first.setText("&First");
        this.first.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_FIRST_MEASURE"));
        this.previous = new MenuItem(this.menu, 8);
        this.previous.setText("&Previous");
        this.previous.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_PREVIOUS_MEASURE"));
        this.next = new MenuItem(this.menu, 8);
        this.next.setText("&Next");
        this.next.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_NEXT_MEASURE"));
        this.last = new MenuItem(this.menu, 8);
        this.last.setText("&Last");
        this.last.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_LAST_MEASURE"));
        new MenuItem(this.menu, 2);
        this.addMeasure = new MenuItem(this.menu, 8);
        this.addMeasure.setText("&Add Measure");
        this.addMeasure.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("ADD_MEASURE"));
        this.removeMeasure = new MenuItem(this.menu, 8);
        this.removeMeasure.setText("&Remove Measure");
        this.removeMeasure.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("REMOVE_MEASURE"));
        new MenuItem(this.menu, 2);
        this.copyMeasure = new MenuItem(this.menu, 8);
        this.copyMeasure.setText("&Copy Measure");
        this.copyMeasure.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("COPY_MEASURE"));
        this.pasteMeasure = new MenuItem(this.menu, 8);
        this.pasteMeasure.setText("&Paste Measure");
        this.pasteMeasure.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("PASTE_MEASURE"));
        this.measureMenuItem.setText("&Measure");
        this.measureMenuItem.setMenu(this.menu);
    }

    public void update() {
        Caret caret = this.tablatureEditor.getTablature().getCaret();
        SongTrackCoords track = caret.getSongTrackCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        this.previous.setEnabled(measure.getMeasureId() > 0);
        this.next.setEnabled(measure.getMeasureId() + 1 < track.getTrack().getMeasures().size());
    }
}

