/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;

public class EditMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem editMenuItem;
    private Menu menu;
    private MenuItem undo;
    private MenuItem redo;

    public EditMenuItem(Shell shell, Menu parent, int style, TablatureEditor tablatureEditor) {
        this.editMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.undo = new MenuItem(this.menu, 8);
        this.undo.setImage(new Image((Device)this.menu.getDisplay(), TuxGuitar.getResourcePath(this, "undo.png")));
        this.undo.setText("&Undo");
        this.undo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    EditMenuItem.this.tablatureEditor.getUndoManager().undo();
                }
                catch (CannotUndoException e) {
                    e.printStackTrace();
                }
            }
        });
        this.redo = new MenuItem(this.menu, 8);
        this.redo.setImage(new Image((Device)this.menu.getDisplay(), TuxGuitar.getResourcePath(this, "redo.png")));
        this.redo.setText("&Redo");
        this.redo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    EditMenuItem.this.tablatureEditor.getUndoManager().redo();
                }
                catch (CannotRedoException e) {
                    e.printStackTrace();
                }
            }
        });
        this.editMenuItem.setText("&Edit");
        this.editMenuItem.setMenu(this.menu);
    }

    public void update() {
    }
}

