/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

public class ChangeTunningTrackAction
extends Action {
    public static final String NAME = "CHANGE_TUNNING_TRACK";
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[7];
    private int stringCount;

    public ChangeTunningTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords trackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        if (trackCoords != null) {
            this.stringCount = trackCoords.getTrack().getStrings().size();
            this.initTempStirngs(trackCoords.getTrack().getStrings());
            final Shell dialog = new Shell(shell, 67680);
            GridLayout layout = new GridLayout(7, true);
            layout.verticalSpacing = 40;
            layout.horizontalSpacing = 0;
            dialog.setLayout((Layout)layout);
            String[] tunningTexts = this.getAllValueNames();
            int i = 0;
            while (i < 7) {
                this.stringSpinners[i] = new TunningSpinner((Composite)dialog, 0);
                this.stringSpinners[i].setTexts(tunningTexts);
                ++i;
            }
            this.updateTunningSpinner();
            Label stringCountLabel = new Label((Composite)dialog, 0);
            stringCountLabel.setText("Strings:");
            final Spinner stringCountSpinner = new Spinner((Composite)dialog, 2048);
            GridData stringCountSpinnerData = new GridData(40, 15);
            stringCountSpinnerData.horizontalSpan = 4;
            stringCountSpinner.setLayoutData((Object)stringCountSpinnerData);
            stringCountSpinner.setMinimum(4);
            stringCountSpinner.setMaximum(7);
            stringCountSpinner.setSelection(this.stringCount);
            stringCountSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChangeTunningTrackAction.this.stringCount = stringCountSpinner.getSelection();
                    ChangeTunningTrackAction.this.setDefaultTunning();
                    ChangeTunningTrackAction.this.updateTunningSpinner();
                }
            });
            Button buttonOK = new Button((Composite)dialog, 8);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData((Object)new GridData(128));
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ChangeTunningTrackAction.this.changeInstrumentStrings();
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button((Composite)dialog, 8);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.pack();
            dialog.open();
            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    private void changeInstrumentStrings() {
        int stringNumber = 1;
        ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>();
        int i = this.stringCount - 1;
        while (i >= 0) {
            strings.add(new InstrumentString(stringNumber, this.stringSpinners[i].getSelection()));
            ++stringNumber;
            --i;
        }
        SongTrackCoords trackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        trackCoords.changeInstrumentStrings(strings);
        new SyncThread(this.getEditor(), new Runnable(){

            public void run() {
                ChangeTunningTrackAction.this.updateTablature();
                ChangeTunningTrackAction.this.redraw();
            }
        }).start();
    }

    private void updateTunningSpinner() {
        int spinnerIndex = this.tempStrings.size() - 1;
        Iterator it = this.tempStrings.iterator();
        while (it.hasNext()) {
            InstrumentString string = (InstrumentString)it.next();
            this.stringSpinners[spinnerIndex].setSelection(string.getValue());
            this.stringSpinners[spinnerIndex].setVisible(true);
            --spinnerIndex;
        }
        int i = this.tempStrings.size();
        while (i < 7) {
            this.stringSpinners[i].setSelection(0);
            this.stringSpinners[i].setVisible(false);
            ++i;
        }
    }

    private void initTempStirngs(List realStrings) {
        this.tempStrings = new ArrayList();
        int i = 0;
        while (i < realStrings.size()) {
            InstrumentString realString = (InstrumentString)realStrings.get(i);
            this.tempStrings.add(realString.clone());
            ++i;
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();
        switch (this.stringCount) {
            case 7: {
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                this.tempStrings.add(new InstrumentString(7, 35));
                break;
            }
            case 6: {
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                break;
            }
            case 5: {
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                this.tempStrings.add(new InstrumentString(5, 23));
                break;
            }
            case 4: {
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
            }
        }
    }

    private String[] getAllValueNames() {
        String[] valueNames = new String[120];
        int i = 0;
        while (i < valueNames.length) {
            valueNames[i] = this.getValueName(i);
            ++i;
        }
        return valueNames;
    }

    private String getValueName(int value) {
        String name = null;
        int octave = value / 12;
        switch (value -= octave * 12) {
            case 0: {
                name = "C";
                break;
            }
            case 1: {
                name = "C#";
                break;
            }
            case 2: {
                name = "D";
                break;
            }
            case 3: {
                name = "D#";
                break;
            }
            case 4: {
                name = "E";
                break;
            }
            case 5: {
                name = "F";
                break;
            }
            case 6: {
                name = "F#";
                break;
            }
            case 7: {
                name = "G";
                break;
            }
            case 8: {
                name = "G#";
                break;
            }
            case 9: {
                name = "A";
                break;
            }
            case 10: {
                name = "Bb";
                break;
            }
            case 11: {
                name = "B";
            }
        }
        return String.valueOf(name) + octave;
    }

    private class TunningSpinner
    extends Composite {
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;

        public TunningSpinner(Composite parent, int style) {
            super(parent, style);
            this.setLayout(this.createLayout(2));
            this.init();
        }

        private void init() {
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(30, 22));
            this.buttonComposite = new Composite((Composite)this, 0);
            this.buttonComposite.setLayout(this.createLayout(1));
            this.upButton = new Button(this.buttonComposite, 132);
            this.upButton.setLayoutData((Object)new GridData(15, 15));
            this.downButton = new Button(this.buttonComposite, 1028);
            this.downButton.setLayoutData((Object)new GridData(15, 15));
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;
            this.text.setEditable(false);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ TunningSpinner this$1;
                {
                    this.this$1 = tunningSpinner;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.setSelection(TunningSpinner.access$0(this.this$1) + 1);
                }
            });
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ TunningSpinner this$1;
                {
                    this.this$1 = tunningSpinner;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.setSelection(TunningSpinner.access$0(this.this$1) - 1);
                }
            });
        }

        private Layout createLayout(int numColumns) {
            GridLayout layout = new GridLayout(numColumns, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            return layout;
        }

        public void setTexts(String[] texts) {
            this.texts = texts;
            this.minSelection = 0;
            this.maxSelection = texts.length - 1;
        }

        public int getSelection() {
            return this.selection;
        }

        public void setSelection(int selection) {
            if (selection >= this.minSelection && selection <= this.maxSelection) {
                this.selection = selection;
                if (this.texts != null) {
                    this.text.setText(this.texts[selection]);
                }
            }
        }

        static /* synthetic */ int access$0(TunningSpinner tunningSpinner) {
            return tunningSpinner.selection;
        }
    }
}

