/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;

public class ChangeNoteAction
extends Action {
    public static final String NAME = "CHANGE_NOTE";

    public ChangeNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        if (e instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)e;
            if (this.isNumber(keyEvent.character)) {
                boolean isPercusionTrack;
                int value = Integer.parseInt(Character.toString(keyEvent.character));
                int lastAdded = -1;
                TypedEvent lastEvent = this.getLastEvent();
                if (lastEvent instanceof KeyEvent) {
                    KeyEvent lastKeyEvent = (KeyEvent)lastEvent;
                    if (this.isNumber(lastKeyEvent.character)) {
                        lastAdded = Integer.parseInt(Character.toString(lastKeyEvent.character));
                    }
                }
                if (((isPercusionTrack = this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().isPercusionTrack()) || lastAdded == 1 || lastAdded == 2) && lastAdded >= 0) {
                    value = Integer.parseInt(String.valueOf(lastAdded) + value);
                }
                this.addNote(value);
                this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
                this.redraw();
                return true;
            }
        }
        return false;
    }

    private boolean isNumber(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    private void addNote(int value) {
        Caret caret = this.getEditor().getTablature().getCaret();
        Duration duration = (Duration)caret.getDuration().clone();
        InstrumentString string = new InstrumentString(caret.getSelectedString().getNumber(), caret.getSelectedString().getValue());
        Note note = new Note(value, caret.getPosition(), duration, 64, string.getNumber(), false);
        caret.getMeasureCoords().addNote(note);
    }
}

