/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.song.managers.SongManager;

public class TuxGuitar {
    private static TuxGuitar instance;
    private String basePath = String.valueOf(new File("").getAbsolutePath()) + File.separator;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private TablatureEditor tablatureEditor;
    private ActionContainer actionContainer;
    private ItemContainerManager itemContainerManager;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TuxGuitar.instance().displayGUI();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TuxGuitar instance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.herac.tuxguitar.gui.TuxGuitar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            instance = new TuxGuitar();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void displayGUI() {
        this.display = new Display();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setText("Tux-Guitar");
        this.songManager = new SongManager();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        this.initActions();
        this.initItems();
        this.tablatureEditor.showTablature(this.shell);
        this.shell.setSize(640, 480);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        this.songManager.getPlayer().close();
        System.exit(0);
    }

    private void initItems() {
        this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
        this.itemContainerManager.createMenu(this.shell);
        this.itemContainerManager.createToolbar(this.shell);
    }

    private void initActions() {
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }

    public Action getAction(String name) {
        return this.actionContainer.getAction(name);
    }

    public ItemContainerManager getItemContainerManager() {
        return this.itemContainerManager;
    }

    public ActionContainer getActionContainer() {
        return this.actionContainer;
    }

    public static String getResourcePath(Object o, String file) {
        return String.valueOf(TuxGuitar.instance().basePath) + "files" + File.separator + file;
    }

    private String getBasePath() {
        return this.basePath;
    }
}

