/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _SENNA_IN_H
#define _SENNA_IN_H
#include "config.h"

#ifdef USE_AIO
/* #define __USE_XOPEN2K 1 */
#define _XOPEN_SOURCE 600
#else
#define _XOPEN_SOURCE 500
#endif /* USE_AIO */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif /* HAVE_STDINT_H */

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif /* HAVE_SYS_PARAM_H */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_SYS_MMAN_H
#include <sys/mman.h>
#endif /* HAVE_SYS_MMAN_H */

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else /* HAVE_SYS_TIME_H */
#include <sys/timeb.h>
#endif /* HAVE_SYS_TIME_H */

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /* HAVE_SYS_RESOURCE_H */

#ifdef WIN32
#pragma warning(disable: 4996)
#include <io.h>
#include <basetsd.h>
#include <process.h>
#include <windows.h>
#include <stddef.h>
#include <windef.h>
#define PATH_MAX (MAX_PATH - 1)
#define inline _inline
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#define unlink _unlink
#define open _open
#define lseek _lseek
#define read _read
#define getpid _getpid
#if _MSC_VER < 1400
#define fstat _fstat
#endif /* _MSC_VER < 1400 */
#define write _write
#define close _close
#define usleep Sleep
#define uint8_t UINT8
#define int8_t INT8
#define int_least8_t INT8
#define uint_least8_t UINT8
#define uint16_t UINT16
#define int32_t INT32
#define uint32_t UINT32
#define uint64_t UINT64
#define PATH_SEPARATOR "\\"
#else /* WIN32 */
#ifndef PATH_MAX
#if defined(MAXPATHLEN)
#define PATH_MAX MAXPATHLEN
#else /* MAXPATHLEN */
#define PATH_MAX 1024
#endif /* MAXPATHLEN */
#endif /* PATH_MAX */
#ifndef INT_LEAST8_MAX
typedef char int_least8_t;
#endif /* INT_LEAST8_MAX */
#ifndef UINT_LEAST8_MAX
typedef unsigned char uint_least8_t;
#endif /* UINT_LEAST8_MAX */
#define PATH_SEPARATOR "/"
#endif /* WIN32 */

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
typedef pthread_mutex_t sen_mutex;
#define MUTEX_INIT(m) pthread_mutex_init(&m, NULL)
#define MUTEX_LOCK(m) pthread_mutex_lock(&m)
#define MUTEX_UNLOCK(m) pthread_mutex_unlock(&m)
#define MUTEX_DESTROY(m)
#else /* HAVE_PTHREAD_H */
#ifdef WIN32
typedef CRITICAL_SECTION sen_mutex;
#define MUTEX_INIT(m) InitializeCriticalSection(&m)
#define MUTEX_LOCK(m) EnterCriticalSection(&m)
#define MUTEX_UNLOCK(m) LeaveCriticalSection(&m)
#define MUTEX_DESTROY(m) DeleteCriticalSection(&m)
#else /* WIN32 */
/* todo */
#endif /* WIN32 */
#endif /* HAVE_PTHREAD_H */

#ifdef __GNUC__
#if (defined(__i386__) || defined(__x86_64__))
#define SEN_ATOMIC_ADD_EX(p,i,r) \
  __asm__ __volatile__ ("lock; xaddl %0,%1" : "=r"(r), "=m"(*p) : "0"(i), "m" (*p))
#elif (defined(__PPC__) || defined(__ppc__))
#define SEN_ATOMIC_ADD_EX(p,i,r) \
  __asm__ __volatile__ ("\n1:\n\tlwarx %0, 0, %1\n\tadd %0, %0, %2\n\tstwcx. %0, 0, %1\n\tbne- 1b\n\tsub %0, %0, %2" : "=&r" (r) : "r" (p), "r" (i) : "cc", "memory");
#else
// todo
#endif
#elif defined WIN32 /* __GNUC__ */ 
#define SEN_ATOMIC_ADD_EX(p,i,r) \
  (r) = (uint32_t)InterlockedExchangeAdd((int32_t *)(p), (int32_t)(i));
#else /* __GNUC__ */
// todo
#endif /* __GNUC__ */

typedef uint8_t byte;

#ifndef _SENNA_H
#include "senna.h"
#endif /* _SENNA_H */

extern int sen_query_escalation_threshold;

#endif /* _SENNA_IN_H */
