/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _SEN_STR_H
#define _SEN_STR_H

#ifndef _SENNA_H
#include "senna_in.h"
#endif /* _SENNA_H */

#ifdef	__cplusplus
extern "C" {
#endif

#define SEN_STR_REMOVEBLANK 1
#define SEN_STR_WITH_CTYPES 2
#define SEN_STR_WITH_CHECKS 4

enum {
  sen_str_null = 0,
  sen_str_alpha,
  sen_str_digit,
  sen_str_symbol,
  sen_str_hiragana,
  sen_str_katakana,
  sen_str_kanji,
  sen_str_others
};

extern const char * sen_enc_string[];

typedef struct {
  uint32_t ctype;
  char *start;
  uint32_t length;
} sen_substr;

typedef struct _sen_str_splitter sen_str_splitter;

typedef struct {
  const char *orig;
  size_t orig_blen;
  char *norm;
  size_t norm_blen;
  uint_least8_t *ctypes;
  int_least8_t *checks;
  size_t length;
  int flags;
  sen_encoding encoding;
} sen_nstr;

sen_str_splitter *sen_str_splitter_open(char *str);
char *sen_str_splitter_next(sen_str_splitter *s, int *ctype);
sen_rc sen_str_splitter_close(sen_str_splitter *s);

int sen_str_split(char *str, sen_substr *res, int max, char **rest);

int sen_str_get_prefix_order(const char *str);

sen_nstr *sen_nstr_open(const char *str, size_t str_len, sen_encoding encoding, int flags);
sen_nstr *sen_fakenstr_open(const char *str, size_t str_len, sen_encoding encoding, int flags);
sen_rc sen_nstr_close(sen_nstr *nstr);

size_t sen_str_charlen(const char *str, sen_encoding encoding);
size_t sen_str_charlen_nonnull(const char *str, const char *end, sen_encoding encoding);
size_t sen_str_len(const char *str, sen_encoding encoding, const char **last);
sen_rc sen_str_fin(void);

#define SEN_NSTR_BLANK 0x80
#define SEN_NSTR_ISBLANK(c) (c & 0x80)
#define SEN_NSTR_CTYPE(c) (c & 0x7f)

void *sen_malloc(size_t size, const char* file, int line);
void *sen_calloc(size_t size, const char* file, int line);
void sen_free(void *ptr, const char* file, int line);
void *sen_realloc(void *ptr, size_t size, const char* file, int line);
char *sen_strdup(const char *s, const char* file, int line);
void sen_assert(int cond, const char* file, int line, const char* func);
int sen_isspace(const char *s, sen_encoding encoding);

#define SEN_MALLOC(s) sen_malloc(s,__FILE__,__LINE__)
#define SEN_CALLOC(s) sen_calloc(s,__FILE__,__LINE__)
#define SEN_REALLOC(p,s) sen_realloc(p,s,__FILE__,__LINE__)
#define SEN_FREE(p) sen_free(p,__FILE__,__LINE__)
#define SEN_STRDUP(s) sen_strdup(s,__FILE__,__LINE__)
#ifdef DEBUG
#define SEN_ASSERT(s) sen_assert((s),__FILE__,__LINE__,__FUNCTION__)
#else
#define SEN_ASSERT(s)
#endif

#ifdef __cplusplus
}
#endif

#endif /* _SEN_STR_H */
