/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include "str.h"

int
main(int argc, char **argv)
{
  sen_nstr *nstr;
  unsigned char buf[0x100000];
  sen_encoding enc = sen_enc_euc_jp;
  if (argc < 2) {
    fputs("usage: stest [euc|sjis]\n", stderr);
    return -1;
  }
  enc = *argv[1] == 'e' ? sen_enc_euc_jp : sen_enc_sjis;
  while (!feof(stdin)) {
    fgets(buf, 0x100000, stdin);
    nstr = sen_nstr_open(buf, enc, 0);
    puts(nstr->norm);
    {
      uint_least8_t *ip;
      for (ip = nstr->ctypes; *ip; ip++) {
	switch(*ip & 0x7f) {
	case sen_str_alpha : putchar('a'); break;
	case sen_str_digit : putchar('n'); break;
	case sen_str_symbol : putchar('s'); break;
	case sen_str_hiragana : putchar('h'); break;
	case sen_str_katakana : putchar('k'); break;
	case sen_str_kanji : putchar('K'); break;
	case sen_str_others : putchar('o'); break;
	default : putchar('e'); break;	
	}
	if (SEN_NSTR_ISBLANK(*ip)) { putchar(' '); }
      }
      putchar('\n');
    }
    sen_nstr_close(nstr);
  }
  return 0;
}

/*
int
main(int argc, char **argv)
{
  unsigned char buf[0x100000], *p;
  while (!feof(stdin)) {
  fgets(buf, 0x100000, stdin);
  for (p = buf; *p;) {
    size_t l = sen_str_charlen(p, sen_enc_utf8);
    while(l--) {
      putchar(*p);
      p++;
    }
    putchar('|');
  }
  }
  puts("completed!!");
  return 0;
}
*/
