/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qtextedit.h>
#include <qprocess.h>
//#####################
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>

#include "segatex_audit2allow.h"
#include "segatex_audit2allow_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexAudit2allow::SegatexAudit2allow(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("audit2allow(only root can do this)"));
		lastreloadCheckBox = new QCheckBox(tr("read input only after the last reload"), this);
		requiresCheckBox = new QCheckBox(tr("generate require statements for rules"), this);
		referenceCheckBox = new QCheckBox(tr("generate refpolicy style output"), this);
		verboseCheckBox = new QCheckBox(tr("explain genetated output"), this);
		explainCheckBox = new QCheckBox(tr("fully explain genetated output"), this);
		//targetedCheckBox->setChecked(true);
		//strictCheckBox->setChecked(true);
		//mlsCheckBox->setChecked(true);
		//passwordLineEdit = new QLineEdit( this );
		//passwordLineEdit->setEchoMode(QLineEdit::Password);
		audit2allowButton = new QPushButton(tr("&audit2allow"), this);
		closeButton = new QPushButton(tr("&Close"), this);
		audit2allowButton->setDefault(true);

		connect(audit2allowButton, SIGNAL(clicked()), this, SLOT(audit2allow_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		QVBoxLayout *leftLayout = new QVBoxLayout;
		leftLayout->addWidget(lastreloadCheckBox);
		leftLayout->addWidget(requiresCheckBox);
		leftLayout->addWidget(referenceCheckBox);
		leftLayout->addWidget(verboseCheckBox);
		leftLayout->addWidget(explainCheckBox);

		QVBoxLayout *rightLayout = new QVBoxLayout;
		//rightLayout->addWidget(passwordLineEdit);
		rightLayout->addWidget(audit2allowButton);
		rightLayout->addWidget(closeButton);
		rightLayout->addStretch(1);

		QHBoxLayout *mainLayout = new QHBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(leftLayout);
		mainLayout->addLayout(rightLayout);
		//needs here to be declared for window newly opened unless segmentation fault occurs
		selinux_audit2allow_process = 0;
}
/*connects signal to close this window when yum process window's close button is clicked*/
void SegatexAudit2allow::audit2allow_clicked()
{
	if(!selinux_audit2allow_process) {
		selinux_audit2allow_process = new SegatexAudit2allowProcess(this);
		connect(selinux_audit2allow_process, SIGNAL(audit2allow_prosess_close_button_clicked()), this, SLOT(close()));
		connect(closeButton, SIGNAL(clicked()), selinux_audit2allow_process, SLOT(close()));
	}
	selinux_audit2allow_process->show();
	selinux_audit2allow_process->raise();
	selinux_audit2allow_process->setActiveWindow();
}
/*unused*/
unsigned long  SegatexAudit2allow::getuid_uid_value()
{
	struct passwd *passwd; /* man getpwuid */
	unsigned long uid_value;
	passwd = getpwuid ( getuid()); /* Get the uid of the running processand use it to get a record from /etc/passwd */
	uid_value = (unsigned long) getpwuid(getuid())->pw_uid;
	/*
	printf("\n The Real User Name is %s ", passwd->pw_gecos);
	printf("\n The Login Name is %s ", passwd->pw_name);
	printf("\n The Home Directory is %s", passwd->pw_dir);
	printf("\n The Login Shell is %s ", passwd->pw_shell);
	printf("\n The Passwd is %s ", getpwuid(getuid()) >pw_passwd);
	printf("\n The uid is %lu ", (unsigned long) getpwuid(getuid())->pw_uid);
	printf("\n The gid is %lu \n\n", (unsigned long) getpwuid(getuid())->pw_gid);
	*/
	//cout << "getuid_uid_value" << uid_value << endl;

	return uid_value;
}
