/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
/*

segatex written by Shintaro Fujiwara.
This code is dedicated to my daughter, mone.
*/
/*uninstd.h should be the first.*/
#include <unistd.h>
#include <stdio.h>
#include <time.h>

#include <iostream>
#include <fstream>
#include <string.h>
#include <vector>
#include <algorithm>
#include <map>
#include <boost/regex.hpp>
#include <qfile.h>
#include <qtextedit.h>
//#include <qdatastream.h>
#include <qlineedit.h>
//#include <qtimer.h>
#include <qprocess.h>
//#include <qprogressbar.h>
//#include <qprogressdialog.h>
//#include <qapplication.h>
/*for segate_show_status()*/
#include <selinux/selinux.h>
#include <selinux/get_default_type.h>
/*for segatex_show_ps()*/
#include <stdlib.h>
/*for segatex_solve_problem()*/
#include <sys/io.h>
//#include <fcntl.h>
//#include <sys/stat.h>
//#include <sys/types.h>
//#include <boost/tokenizer.hpp>

/*These should be globals.*/

int log_state = 0;
time_t the_time;
long log_from_time = 0;
int log_from_time_int = 0;

QProcess *process;
QProcess *process1;
//QProgressBar* progress_bar;
//QProgressDialog* pd;
//QTimer progress_bar_timer;


#define MAX_LOG 8460

/*prototype declaration*/
int segatex_set_time_real();
int segatex_set_time_all_real();
int segatex_cat_files();
const char* segatex_show_installed_policy();
void segatex_fixfiles_relabel();
void segatex_show_status();
void segatex_set_time();
void segatex_set_time_all();
void segatex_yum_install();
void segatex_yum_update();
void segatex_module_list();
void segatex_load_from_my_policy();
void segatex_load_from_file_contexts();
void segatex_load_from_file_contexts_local();
void segatex_ls_laZ();
void segatex_write_file_contexts_local();
void segatex_remove_my_policy();
void segatex_write_to_my_policy();
void segatex_show_yum_update();
void segatex_show_help();
void segatex_show_interface();
/*
void segatex_qtimer();
void segatex_advance_progress_bar();
void segatex_stop_progress_bar();
void operation();
*/
void updateOutputTextEdit();
void updateOutputTextEdit1();
void processExited();
void processExited1();
void readFromStdout();
void readFromStdout1();

const char* segatex::segatex_show_installed_policy()
{
        using namespace std;
	using namespace boost;
	const char* installed_policy="";

	const char* policy_targeted = "targeted";
	const char* policy_strict = "strict";
	const char* policy_mls = "mls";

	regex policy_targeted_exp(policy_targeted);
	regex policy_strict_exp(policy_strict);
	regex policy_mls_exp(policy_mls);

	const char* pol_ro = selinux_policy_root();

	cmatch what;
	if(regex_search(pol_ro,what,policy_targeted_exp)){
		installed_policy="targeted";
	} 
	if(regex_search(pol_ro,what,policy_strict_exp)){
		installed_policy="strict";
	} 
	if(regex_search(pol_ro,what,policy_mls_exp)){
		installed_policy="mls";
	} 
	return installed_policy;
}

void segatex::segatex_show_status()
{
        using namespace std;
        //const char* filename_sestatus="./segatex_sestatus";
        const char* filename_sestatus="/root/segatex/segatex_sestatus";
        ofstream os;
        os.open(filename_sestatus);
        if(os){
                const char* pol_ro = selinux_policy_root();
                const char* def_tp_pa = selinux_default_type_path();
                string se_pol_rt_pre = "Your selinux policy root is ";
                string se_def_tp_pa_pre = "Your selinux default type path is ";
                string se_pol_rt = pol_ro;
                string se_pol_rt_end = "You are running SELinux in";
                int enforce_state = security_getenforce();
                string en_st = "";
                if (enforce_state == 1){
                        en_st = "Enforcing.";
                }else{
                        en_st = "Permissive.";
                }
		//added for test
		const char* system_policy=segatex::segatex_show_installed_policy();
		string system_policy_str=system_policy;
		//added for test end
                os << se_pol_rt_pre << endl
                << se_pol_rt << endl
                << se_def_tp_pa_pre << endl
                << def_tp_pa << endl
                << se_pol_rt_end << endl
                << en_st <<endl << endl;
		string en_st_head="";
		string en_st_tail=""; 
		if(en_st=="Enforcing."){
			en_st_head="Which means enforced in ";
			en_st_tail="-mode."; 
		}
		if(en_st=="Permissive."){
			en_st_head="Which permits any access in ";
			en_st_tail="-mode."; 
		}
		string en_st_echo="";
		en_st_echo = en_st_head + system_policy_str + en_st_tail;
		os << en_st_echo << endl;
                os.close();
                QFile file( filename_sestatus); // Read the text from a file
                if ( file.open( IO_ReadOnly ) ) {
                        QTextStream stream( &file );
                        textEdit1->setText( stream.read() );
                }
        }
}

void segatex::segatex_autorelabel()
{
        using namespace std;
	FILE *read_fp_sleep_60;
	FILE *read_fp_autorelabel;
	FILE *read_fp_reboot;
	string sleep_60="";
	string autorelabel="touch /.autorelabel";
	string reboot="shutdown -r now";
	const char* sleep_60_char=sleep_60.c_str();
	const char* autorelabel_char=autorelabel.c_str();
	const char* reboot_char=reboot.c_str();
	read_fp_sleep_60=popen(sleep_60_char,"r");
	if(read_fp_sleep_60 != NULL){
		sleep(60);
	}
	pclose(read_fp_sleep_60);
	read_fp_autorelabel=popen(autorelabel_char,"r");
	pclose(read_fp_autorelabel);
	read_fp_reboot=popen(reboot_char,"r");
	pclose(read_fp_reboot);
}

void segatex::segatex_show_autorelabel()
{
        status_label_1->setText("autorelabel button pushed. The system reboots in 60 seconds and relabels itself !");
}

void segatex::segatex_remove_my_policy()
{
        using namespace std;
        #define PWD_BUF 8600
        //const char* remove_file="./remove_echo";
        const char* remove_file="/root/segatex/remove_echo";
        ofstream os;
        os.open(remove_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("/usr/sbin/semodule -r my_policy_by_segatex", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                os.close();
                QFile file( remove_file ); // Read the text from a file
                if ( file.open( IO_ReadOnly ) ) {
                        QTextStream stream( &file );
                        textEdit2->setText( stream.read() );
                }
		status_label_1->setText("Please click module_list button and check policy has been removed !");
        }
}

void segatex::segatex_show_help()
{
        using namespace std;
        const char* help_file="/root/segatex/HELP";
	ifstream is;
	is.open(help_file);
	if(is){
		QFile file( help_file ); 
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit1->setText( stream.read() );
		}
		is.close();
	}else{
		;//do nothing
	}

}

void segatex::segatex_module_list()
{
        using namespace std;
        #define PWD_BUF 8600
        //const char* module_list_file="./module_list";
        const char* module_list_file="/root/segatex/module_list";
        ofstream os;
        os.open(module_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("/usr/sbin/semodule -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                os.close();
                QFile file( module_list_file ); // Read the text from a file
                if ( file.open( IO_ReadOnly ) ) {
                        QTextStream stream( &file );
                        textEdit2->setText( stream.read() );
                }
        }
}

//just opens a file 
void segatex::segatex_load_from_file_contexts()
{
	using namespace std;
	const char* system_policy=segatex::segatex_show_installed_policy();
	string system_policy_str=system_policy;
        string file_contexts_file_pre="/etc/selinux/";
        string file_contexts_file_last="/contexts/files/file_contexts";
        string file_contexts_string=file_contexts_file_pre + system_policy_str + file_contexts_file_last;
        const char* file_contexts=file_contexts_string.c_str();
	ifstream is;
	is.open(file_contexts);
	if(is){
		QFile file( file_contexts ); 
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit3->setText( stream.read() );
		}
		is.close();
	}else{
		;//do nothing
	}
}

//opens a file for editing
void segatex::segatex_load_from_file_contexts_local()
{
	using namespace std;
	const char* system_policy=segatex::segatex_show_installed_policy();
	string system_policy_str=system_policy;
        string file_contexts_file_pre_local="/etc/selinux/";
        string file_contexts_file_last_local="/contexts/files/file_contexts.local";
        string file_contexts_string_local=file_contexts_file_pre_local + system_policy_str + file_contexts_file_last_local;
        const char* file_contexts_local=file_contexts_string_local.c_str();
	ifstream is;
	is.open(file_contexts_local);
	if(is){
		QFile file( file_contexts_local ); 
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
                        textEdit4->setText( stream.read() );
		}
		is.close();
	}else{
		;//do nothing
	}
}

//write to a file
void segatex::segatex_write_file_contexts_local()
{
	using namespace std;
	const char* system_policy=segatex::segatex_show_installed_policy();
	string system_policy_str=system_policy;
	string file_contexts_file_pre_local="/etc/selinux/";
        string file_contexts_file_last_local="/contexts/files/file_contexts.local";
        string touch_com="touch ";
        string file_contexts_string_local=file_contexts_file_pre_local + system_policy_str + file_contexts_file_last_local;
        string touch_file_contexts_string_local=touch_com + file_contexts_file_pre_local + system_policy_str + file_contexts_file_last_local;
        const char* touch_file_contexts_local=touch_file_contexts_string_local.c_str();
        const char* file_contexts_local=file_contexts_string_local.c_str();
	const char* touch_fl="/root/segatex/touch_file_contexts_local";
        ofstream os_pre;
	os_pre.open(touch_fl);
	if(os_pre){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(touch_file_contexts_local, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_pre << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
	}
	ifstream is;
	is.open(file_contexts_local);
	if(is){
		QFile file( file_contexts_local ); 
		if ( file.open( IO_ReadWrite ) ) {
			QTextStream stream( &file );
                        stream << textEdit4->text();
                        textEdit4->setModified( FALSE );
		}
		is.close();
	}else{
		textEdit4->setText("a file does not exists");
		;//do nothing
	}
}

//get lineEdit1 and pass it to process
void segatex::segatex_ls_laZ()
{
	using namespace std;
	QString str;
	str=lineEdit1->text();
	const char* str_char="";
	str_char = str;
	string str_process_pre= "ls -laZ ";
	string str_process= str_process_pre + str_char;

        const char* ls_laZ_file="/root/segatex/ls_laZ";
        ofstream os;
        os.open(ls_laZ_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(str_process.c_str(), "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                os.close();
                QFile file( ls_laZ_file ); // Read the text from a file
                if ( file.open( IO_ReadOnly ) ) {
                        QTextStream stream( &file );
                        textEdit3->setText( stream.read() );
                }
        }
}

void segatex::segatex_load_from_my_policy()
{
	using namespace std;
        //const char* filename_policy="./my_policy_by_segatex.te";
        const char* filename_policy="/root/segatex/my_policy_by_segatex.te";
	ifstream is;
	is.open(filename_policy);
	if(is){
		QFile file( filename_policy ); 
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit2->setText( stream.read() );
		}
		is.close();
	}else{
		;//do nothing
	}
}

void segatex::segatex_write_to_my_policy()
{
	using namespace std;
	//const char* my_policy_file="./my_policy_by_segatex.te";
	const char* my_policy_file="/root/segatex/my_policy_by_segatex.te";
	//const char* load_my_policy_file="./load_my_policy";
	const char* load_my_policy_file="/root/segatex/load_my_policy";
	ifstream os_pre;
	os_pre.open(my_policy_file);
	if(os_pre){
                QFile file( my_policy_file );
                if ( file.open( IO_ReadWrite ) ) {
                        QTextStream stream( &file );
                        stream << textEdit2->text();
                        textEdit2->setModified( FALSE );
                }
		os_pre.close();

		ofstream os;
		os.open(load_my_policy_file);
		if(os){
			//int check=chdir(my_data_dir);
			int check=0;
			if(check==0){
				FILE *read_fp_install;
				FILE *read_fp;
				#define SIZE_TMP 8600
				char buffer[SIZE_TMP];
				int chars_read;
				memset(buffer, '\0', sizeof(buffer));
				//read_fp_install = popen("make -f /usr/share/selinux/devel/Makefile", "r");
				read_fp_install = popen("make -C /root/segatex -f /usr/share/selinux/devel/Makefile", "r");
				if(read_fp_install != NULL){
					chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp_install);
					while(chars_read>0){
						buffer[chars_read -1] = '\0';
						//os << "Reading:-" << endl;
						os << buffer;
						chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp_install);
					}
					pclose(read_fp_install);
				}
				//read_fp = popen("semodule -i my_policy_by_segatex.pp", "r");
				read_fp = popen("/usr/sbin/semodule -i /root/segatex/my_policy_by_segatex.pp", "r");
				if(read_fp != NULL){
					chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
					while(chars_read>0){
						buffer[chars_read -1] = '\0';
						//os << "Reading:-" << endl;
						os << buffer;
						chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
					}
					pclose(read_fp);
				}
			}
			os.close();
			QFile file( load_my_policy_file ); // Read the text from a file
				if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				textEdit2->setText( stream.read() );
			}
		status_label_1->setText("Please click module_list button and check policy has been installed !");
		}
	}
}

void segatex::segatex_show_yum_update()
{
        status_label_1->setText("yum install/updating SELinx related rpms and audit rpm. Please wait for a while...");
}

/*
void segatex::segatex_qtimer()
{
	//for progressBar
	progress_bar_timer.start(200, false);
	connect( &progress_bar_timer, SIGNAL( timeout() ),
		     this, SLOT( segatex_advance_progress_bar()) );
}

void segatex::segatex_advance_progress_bar()
{
	progressBar1->setProgress(progressBar1->progress() + 10);
	qApp->processEvents();
}

void segatex::segatex_stop_progress_bar()
{
	progress_bar_timer.stop();
	progressBar1->setProgress(0);
}

void segatex::operation()
{
	int totalSteps = 1000;
	QProgressDialog progress( "Install and updating SELinux related RPMs...", 0 ,  totalSteps,
				  this, "progress", TRUE );
	for ( int i = 0; i < totalSteps; i++ ) {
	    progress.setProgress( i );
	    qApp->processEvents();
	    if ( progress.wasCanceled() )
		break;
	}
	progress.setProgress( totalSteps );
}
*/

void segatex::readFromStdout()
{
	// Read and process the data.
	// Bear in mind that the data might be output in chunks.
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}

void segatex::readFromStdout1()
{
	// Read and process the data.
	// Bear in mind that the data might be output in chunks.
	QByteArray data = process1->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}

void segatex::updateOutputTextEdit()
{
	// Read and process the data.
	// Bear in mind that the data might be output in chunks.
	QByteArray data = process->readStderr();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}

void segatex::updateOutputTextEdit1()
{
	// Read and process the data.
	// Bear in mind that the data might be output in chunks.
	QByteArray data = process1->readStderr();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}

void segatex::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("yum install process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("yum install process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	textEdit1->append(tr("yum update process will start please wait"));
	textEdit1->append(tr("\n"));
	segatex_yum_update();
}

void segatex::processExited1()
{
	if(process1->normalExit()){
		textEdit1->append(tr("yum update process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("yum update process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process1;
	process1 = 0;
	yum_install_update->setEnabled(true);
}

void segatex::segatex_yum_install()
{
	yum_install_update->setEnabled(false);
	process = new QProcess(this);
	process->addArgument("yum");
	process->addArgument("-y");
	process->addArgument("install");
	process->addArgument("audit");
	process->addArgument("selinux-policy");
	process->addArgument("selinux-policy-devel");
	process->addArgument("selinux-policy-mls");
	process->addArgument("selinux-policy-strict");
	process->addArgument("selinux-policy-targeted");
	process->addArgument("libsepol");
	process->addArgument("libselinux");
	process->addArgument("libselinux-devel");
	process->addArgument("libselinux-python");
	process->addArgument("libsemanage");
	process->addArgument("policycoreutils");
	process->addArgument("checkpolicy");
	//connect(process, SIGNAL(readyReadStdout()),this,SLOT(segatex_advance_progress_bar()));
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	//for progressbar to stop 
	//connect(process, SIGNAL(processExited()),this,SLOT(segatex_stop_progress_bar()));
	process->start();
}

void segatex::segatex_yum_update()
{
	yum_install_update->setEnabled(false);
	process1 = new QProcess(this);
	process1->addArgument("yum");
	process1->addArgument("-y");
	process1->addArgument("update");
	process1->addArgument("audit");
	process1->addArgument("selinux-policy");
	process1->addArgument("selinux-policy-devel");
	process1->addArgument("selinux-policy-mls");
	process1->addArgument("selinux-policy-strict");
	process1->addArgument("selinux-policy-targeted");
	process1->addArgument("libsepol");
	process1->addArgument("libselinux");
	process1->addArgument("libselinux-devel");
	process1->addArgument("libselinux-python");
	process1->addArgument("libsemanage");
	process1->addArgument("policycoreutils");
	process1->addArgument("checkpolicy");
	//connect(process1, SIGNAL(readyReadStdout()),this,SLOT(segatex_advance_progress_bar()));
	connect(process1, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout1()));
	connect(process1, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit1()));
	connect(process1, SIGNAL(processExited()),this,SLOT(processExited1()));
	//for progressbar to stop 
	//connect(process1, SIGNAL(processExited()),this,SLOT(segatex_stop_progress_bar()));
	process1->start();
}

void segatex::segatex_audit_2_allow()
{
	using namespace std;
	#define PWD_BUF 8600
	//const char* audit_2_allow_file="./local.te";
	const char* audit_2_allow_file="/root/segatex/local.te";
	ofstream os;
	os.open(audit_2_allow_file);
	if(os){
		FILE *read_fp;
		#define SIZE_TMP 8600
		char buffer[SIZE_TMP];
		int chars_read;
		memset(buffer, '\0', sizeof(buffer));
		read_fp = popen("/usr/bin/audit2allow -m local -a", "r");
		if(read_fp != NULL){
			chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			while(chars_read>0){
				buffer[chars_read -1] = '\0';
				//os << "Reading:-" << endl;
				os << buffer;
				chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
		}
		os.close();
		QFile file( audit_2_allow_file ); // Read the text from a file
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit1->setText( stream.read() );
		}
	}
}

int segatex::segatex_cat_files()
{
	int cat_files_state = 1;
	using namespace std;
	#define PWD_BUF 8600
	const char* avc_file="/root/segatex/avc_file";
	ofstream os;
	os.open(avc_file);
	if(os){
		FILE *read_fp;
		#define SIZE_TMP 8600
		char buffer[SIZE_TMP];
		int chars_read;
		memset(buffer, '\0', sizeof(buffer));
		read_fp = popen("cat /var/log/messages /var/log/audit/audit.log > /root/segatex/audit_messages.log", "r");
		if(read_fp != NULL){
			chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			while(chars_read>0){
				buffer[chars_read -1] = '\0';
				os << buffer;
				chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
			cat_files_state = 0;
		}
		os.close();
	}
	return cat_files_state;
}

void segatex::segatex_audit_2_why()
{
	using namespace std;
	#define PWD_BUF 8600
	//const char* audit_2_why_file="./local_te_why";
	const char* audit_2_why_file="/root/segatex/local_te_why";
	ofstream os;
	os.open(audit_2_why_file);
	if(os){
		FILE *read_fp;
		#define SIZE_TMP 8600
		char buffer[SIZE_TMP];
		int chars_read;
		memset(buffer, '\0', sizeof(buffer));
		read_fp = popen("/usr/sbin/audit2why < /var/log/audit/audit.log", "r");
		if(read_fp != NULL){
			chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			while(chars_read>0){
				buffer[chars_read -1] = '\0';
				//os << "Reading:-" << endl;
				os << buffer;
				chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
		}
		os.close();
		QFile file( audit_2_why_file ); // Read the text from a file
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit1->setText( stream.read() );
		}
	}
}

int segatex::segatex_set_time_real()
{
        log_from_time = time((time_t*)0);
        log_from_time_int = (int)log_from_time;
        log_from_time_int = log_from_time_int - 60*30;
        return log_from_time_int;
}
int segatex::segatex_set_time_all_real()
{
        log_from_time_int = 0;
        return log_from_time_int;
}
void segatex::segatex_set_time()
{
	log_state = 1;
}

void segatex::segatex_set_time_all()
{
	log_state = 0;
}

void segatex::segatex_show_interface()
{
	/*ŪɽΰʤƤʤᡢ©ʼʤȤäƶϫƤ...*/

	using namespace std;
	using namespace boost;
	const char* filename="";
	const char* filename_my_log="/root/segatex/audit_log_mine_must_be_here";
        const char* filename_policy="/root/segatex/my_policy_by_segatex.te";
	if(log_state == 0){
		log_from_time_int = segatex::segatex_set_time_all_real(); 
	}
	else if(log_state == 1){
		log_from_time_int = segatex::segatex_set_time_real();
	}
	char buffer_engine[MAX_LOG +1];
        char buffer_c[MAX_LOG];

	//read from engine and store them to v_engine
        const char* filename_engine="/root/segatex/selpaw_interface.csv";

        ifstream is_engine;
        ofstream os_engine_test;
	ofstream os_policy;
        is_engine.open(filename_engine);
	fstream os_my_log(filename_my_log,ios::in | ios::app);
	fstream os_my_log_2(filename_my_log, ios::app);
	//When selpaw_interface.csv is missing.
        if(!is_engine){
		os_policy.open(filename_policy);
		if(os_policy){
			os_policy << "selpaw_interface.csv is missing!!" << endl;
		}
		is_engine.close();
	
		QFile file( filename_policy); // Read the text from a file
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit1->setText( stream.read() );
		}
	//When selpaw_interface.csv exists.
        }else{
		vector<string> v_engine;
		vector<string>::iterator p_engine, p_engine_end;
		do{
			is_engine.getline(buffer_engine, sizeof buffer_engine);
			v_engine.push_back(buffer_engine);
			string buffer_engine_str=buffer_engine;
			//os_engine_test << buffer_engine << endl;
		}while(!is_engine.eof());
		//os_engine_test.close();
		int avc_state = segatex::segatex_cat_files();
		if(avc_state == 0 ){
			filename="/root/segatex/audit_messages.log";
		}else{
			os_policy << "cannot read from log !" << endl;	
		}
		ifstream is;
		is.open(filename);
		//When log is missing.
		if(!is.getline(buffer_c, sizeof buffer_c)){
			os_policy.open(filename_policy);
			if(os_policy){
				os_policy << "There is no line in this log or not running auditd." << endl;
			}
			is.close();
			QFile file( filename_policy); // Read the text from a file
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				textEdit1->setText( stream.read() );
			}
		//When log is existing.
		}else{
			vector<string> v;
			vector<string>::iterator p, p_end;

			vector<string> v2;
			vector<string>::iterator p2_v, p2_v_end;
			vector<string> v3;
			vector<string>::iterator p3_v, p3_v_end;
			multimap<string ,string>::iterator p2,p2_end;
			multimap<string ,string>::iterator p2_m,p2_m_end;
			//write to my_log
			char buffer[MAX_LOG];

			//os_my_logҤ餤ơǸιԤunixtimeintѴѿƤ
			os_my_log.open(filename_my_log);
			if(os_my_log){
				//deniedåѤ
				do{
					os_my_log.getline(buffer, sizeof buffer);
					v3.push_back(buffer);
				}while(!os_my_log.eof());
			}else{
				;//do nothing
			}
			os_my_log.close();
			string u_time_str = "";
			for(p3_v=v3.begin(); p3_v<v3.end()-1;p3_v++){
				u_time_str = *p3_v;
				//cout << u_time_str << endl;
			}
			const char* u_time = "\\([0-9]{10}";
			//cout << u_time_str << endl;
			const char* u_time_char_pre = u_time_str.c_str();
			regex u_time_exp(u_time);
			cmatch what;
			int u_time_int=0;
			int u_time_present_int=0;
			if(regex_search(u_time_char_pre,what,u_time_exp)){
				string u_time_match = what[0];
				string blank_str="";
				u_time_match=u_time_match.replace(0,1,blank_str);
				//cout << u_time_match << endl;
				const char* u_time_char = u_time_match.c_str();
				u_time_int= atoi(u_time_char);
				//cout << u_time_int << endl;
			}else{
				//cout << "no-match" << endl;
			}

			os_my_log_2.open(filename_my_log);
			if(os_my_log_2){
				const char* words="denied";
				//deniedåѤ
				do{
					is.getline(buffer, sizeof buffer);
					if(strstr(buffer,words)){
						const char* buffer_const_char= buffer;
						//⤷u_time_int礭Сos_my_logɵƤ
						if(regex_search(buffer_const_char,what,u_time_exp)){
							string u_time_match_present = what[0];
							//cout << u_time_match_present << endl;
							string blank_str="";
							u_time_match_present=u_time_match_present.replace(0,1,blank_str);
							const char* u_time_match_present_char = u_time_match_present.c_str();
							u_time_present_int= atoi(u_time_match_present_char);
							if(u_time_present_int > u_time_int){
								//cout << "u_time_present_int" << u_time_present_int << endl;
								//cout << "u_time_int" << u_time_int << endl;
								//cout << "buffer:" << buffer << endl;
								os_my_log_2 << buffer << endl;
							}
						}else{
							//cout << "no-match" << endl;
						}
					}
				}while(!is.eof());
			}else{
				;//do nothing
			}
			is.close();
			os_my_log_2.close();

			os_my_log.open(filename_my_log);
			//open policy file
			os_policy.open(filename_policy);
			if(os_policy)
			{
				char buffer[MAX_LOG];
				const char* words="denied";
				//ޥdeniedåѤ
				//եƬ˥ݥ󥿤ưƤ
				os_my_log.seekg(ios::beg);
				do{
					os_my_log.getline(buffer, sizeof buffer);
					if(strstr(buffer,words)){
						v.push_back(buffer);
					}
				}while(!os_my_log.eof());
				//if there are no denied log
				if(v.size()==0){
					os_policy << "Your log is perfect !!" << endl;
					os_policy << "You don't have to configure SELinux policy at all !!" << endl;
					QFile file( filename_policy); // Read the text from a file
						if ( file.open( IO_ReadOnly ) ) {
						QTextStream stream( &file );
						textEdit1->setText( stream.read() );
					}
				//if there are any denied log
				}else{
					const char* den = "denied";
					const char* log_time = "audit\\([0-9]{10}";
					const char* scontext = "scontext([^[:blank:]]*)([:blank:])?";
					const char* scontext_rev = "t_[a-zA-Z0-9_.]([^:]*)?";
					const char* tcontext = "tcontext([^[:blank:]]*)([:blank:])?";
					const char* tcontext_rev = "t_[a-zA-Z0-9_.]([^:]*)?";
					//changed in segatex2.11
					//const char* tclass = "tclass(.*)";
					const char* tclass = "tclass=[a-zA-Z0-9_]*";
					const char* tclass_2 = "[a-zA-Z0-9_]([^=]*)?";
					const char* acc = "\\{(.*)\\}";
					const char* role = ":[a-zA-Z0-9_]*_r";

					regex denied_exp(den);
					regex log_time_exp(log_time);
					regex domain_exp(scontext);
					regex domain_rev_exp(scontext_rev);
					regex resource_exp(tcontext);
					regex resource_rev_exp(tcontext_rev);
					regex object_class_exp(tclass);
					regex object_class_exp_2(tclass_2);
					regex access_vector_exp(acc);
					regex role_exp(role);

					string log_time_string = "";
					int log_time_int = 0;
					string policy_selinux = "";
					string allow_pre = "allow";
					string blank_w = " ";
					string colon = ":";
					string semicolon = ";";
					string domain = "";
					string domain_2 = "";
					string resource = "";
					string resource_2 = "";
					string object_class_pre = "";
					string object_class = "";
					string access_vector = "";
					string role_str = "";
					//string blank_str = "";
					//multimap<string, string>macro_pre;
					multimap<string, string> pattern_matched;
					multimap<string, string>::iterator p_pattern_matched;

					multimap<string, string> pattern_not_matched;
					multimap<string, string>::iterator p_pattern_not_matched;
		/*
					multimap<string, string> pattern_matched_objclass;
					multimap<string, string>::iterator p_pattern_matched_objclass;
		*/
					multimap<string, string> pattern_matched_access_vector;
					multimap<string, string>::iterator p_pattern_matched_access_vector;
		/*
					multimap<string, string> pattern_matched_domain;
					multimap<string, string>::iterator p_pattern_matched_domain;
					multimap<string, string> pattern_matched_tclass;
					multimap<string, string>::iterator p_pattern_matched_tclass;
		*/
		//̾ϡnot_matchedˤʤäƤ뤬Ƥξ֤ޥޥåפɬפȤ߹碌Ƥ*/
					multimap<string, string> pattern_not_matched_objclass;
					multimap<string, string>::iterator p_pattern_not_matched_objclass;
					multimap<string, string> pattern_not_matched_access_vector;
					multimap<string, string>::iterator p_pattern_not_matched_access_vector;
					multimap<string, string> pattern_not_matched_domain;
					multimap<string, string>::iterator p_pattern_not_matched_domain;
					multimap<string, string> pattern_not_matched_tclass;
					multimap<string, string>::iterator p_pattern_not_matched_tclass;
					multimap<string, string> pattern_allow_not_matched_echo;
					multimap<string, string>::iterator p_pattern_allow_not_matched_echo;
					multimap<string, string> pattern_matched_tclassobjclass_interface;
					multimap<string, string>::iterator p_pattern_matched_tclassobjclass_interface;

					vector<string> v_source_interface_pre;
					vector<string>::iterator p_source_interface_pre, p_source_interface_pre_end;

					vector<string> v_matched_tmp_objclass;
					vector<string>::iterator p_matched_tmp_objclass, p_matched_tmp_objclass_end;
					vector<string> v_matched_objclass_accv;
					vector<string>::iterator p_matched_objclass_accv, p_matched_objclass_accv_end;
					vector<string> v_matched_tmp_domain;
					vector<string>::iterator p_matched_tmp_domain, p_matched_tmp_domain_end;

					vector<string> v_tmp_objclass;
					vector<string>::iterator p_tmp_objclass, p_tmp_objclass_end;
					vector<string> v_accv;
					vector<string>::iterator p_accv, p_accv_end;
					vector<string> v_tmp_domain;
					vector<string>::iterator p_tmp_domain, p_tmp_domain_end;
					vector<string> v_dollar_2_domain;
					vector<string>::iterator p_dollar_2_domain, p_dollar_2_domain_end;


					vector<string> v_allow_first;
					vector<string>::iterator p_allow_first, p_allow_first_end;
					vector<string> v_allow_last;
					vector<string>::iterator p_allow_last, p_allow_last_end;
					vector<string> v_domain_interface;
					vector<string>::iterator p_domain_interface, p_domain_interface_end;

					vector<string> v_interface_raw;
					vector<string>::iterator p_interface_raw, p_interface_raw_end;

					vector<string> v_role;
					vector<string>::iterator p_role, p_role_end;

					for(p=v.begin(); p<v.end();p++){
						string source_ready = *p;
						//os_policy << source_ready << endl;
						const char* source = source_ready.c_str();
						cmatch what;
						if(regex_search(source,what,denied_exp)){
							if(regex_search(source,what,domain_exp)){
								domain = what[0];
								//os_policy << "domain:" << domain << endl;
								const char* domain_char = domain.c_str();
								if(regex_search(domain_char,what,role_exp)){
									role_str = what[0];
									string blank_str="";
									role_str=role_str.replace(0,1,blank_str);
									v_role.push_back(role_str.c_str());
									//os_policy << role_str << endl;
								}
								int str_length = strlen(domain.c_str());
								int i=str_length;
								string str_rev="";
								string str_rev_all="";
								for(i=str_length;i>0;i--){
									str_rev = domain.substr(i,1);
									str_rev_all = str_rev_all + str_rev;
								}
								const char* str_rev_all_char = str_rev_all.c_str();
								if(regex_search(str_rev_all_char,what,domain_rev_exp)){
									domain_2 = what[0];
									int str_length = strlen(domain_2.c_str());
									int i=str_length;
									string str_rev="";
									string str_rev_all="";
									for(i=str_length;i>=0;i--){
										str_rev = domain_2.substr(i,1);
										str_rev_all = str_rev_all + str_rev;
									}
									domain = str_rev_all;
								}
							}
							if(regex_search(source,what,resource_exp)){
								resource = what[0];
								int str_length = strlen(resource.c_str());
								int i=str_length;
								string str_rev="";
								string str_rev_all="";
								for(i=str_length;i>0;i--){
									str_rev = resource.substr(i,1);
									str_rev_all = str_rev_all + str_rev;
								}
								const char* str_rev_all_char = str_rev_all.c_str();
								if(regex_search(str_rev_all_char,what,resource_rev_exp)){
									resource_2 = what[0];
									int str_length = strlen(resource_2.c_str());
									int i=str_length;
									string str_rev="";
									string str_rev_all="";
									for(i=str_length;i>=0;i--){
										str_rev = resource_2.substr(i,1);
										str_rev_all = str_rev_all + str_rev;
									}
									resource = str_rev_all;
								}
							}
							if(regex_search(source,what,object_class_exp)){
								object_class_pre = what[0];
								//os_policy << object_class << endl;
								int str_length = strlen(object_class_pre.c_str());
								int i=str_length;
								string str_rev="";
								string str_rev_all="";
								for(i=str_length;i>0;i--){
									str_rev = object_class_pre.substr(i,1);
									str_rev_all = str_rev_all + str_rev;
								}
								const char* str_rev_all_char = str_rev_all.c_str();
								if(regex_search(str_rev_all_char,what,object_class_exp_2)){
									object_class = what[0];
									int str_length = strlen(object_class.c_str());
									int i=str_length;
									string str_rev="";
									string str_rev_all="";
									for(i=str_length;i>=0;i--){
										str_rev = object_class.substr(i,1);
										str_rev_all = str_rev_all + str_rev;
									}
									object_class = str_rev_all;
									//os_policy << object_class << endl;
								}
							}
							if(regex_search(source,what,access_vector_exp)){
								access_vector = what[0];
							}
							policy_selinux = allow_pre + blank_w +
								domain + blank_w + resource + colon + object_class + blank_w + access_vector;
							if(regex_search(source,what,log_time_exp)){
								log_time_string = what[0];
								log_time_string = log_time_string.substr(6);
								log_time_int = atoi(log_time_string.c_str());
							}
							if(log_from_time_int <= log_time_int){
								//os_policy << policy_selinux << endl;
								v2.push_back(policy_selinux.c_str());
							}
						  }
					}
					sort(v2.begin(),v2.end());
					p2_v_end = unique(v2.begin(),v2.end());
					const char* m_pre = "(.*):([^[:space:]]*)([:space:])?";
					const char* m_interface_pre = "[a-z]([^[:space:]]*):([^[:space:]]*)([:space:])?";
					const char* m_domain_pre = "[A-Za-z0-9_.]*_t";
					const char* m_tclass_pre = "[A-Za-z0-9_.]*_t:";
					//changed here at segatex2.11
					const char* m_objclass_pre = ":[a-zA-Z0-9_]*([^[:space:]]*)([:space:])?";
					const char* m_acc = "\\{(.*)\\}";
					const char* m_blank = "[a-zA-Z0-9_](.*)[a-zA-Z0-9_]";
					regex m_pre_exp(m_pre);
					regex m_interface_pre_exp(m_interface_pre);
					regex m_domain_pre_exp(m_domain_pre);
					regex m_tclass_pre_exp(m_tclass_pre);
					regex m_objclass_pre_exp(m_objclass_pre);
					regex m_access_vector_exp(m_acc);
					regex m_blank_exp(m_blank);
					string source_macro_pre="";
					string source_interface_pre="";
					string source_domain_pre="";
					string source_tclass_pre="";
					string source_objclass_pre="";
					string source_access_vector_pre="";
					string source_interface_pre_prev="";
					string source_interface_engine="";
					string access_vector_m = "";
					string blank_m = "";

					int source_macro_numbers=0;
					for(p2_v=v2.begin(); p2_v < v2.end(); p2_v++){
						string source_macro = *p2_v;

						/*for debug*/
						//ޥʸ
						//os_policy << source_macro << endl;
						/*end for debug*/
						const char* source_m = source_macro.c_str();
						cmatch what;
						if(regex_search(source_m,what,m_domain_pre_exp)){
							source_domain_pre  = what[0];
							//2.12ɮäѤꤳѤΤɬפä
							v_tmp_domain.push_back(source_domain_pre.c_str());
							/*for debug*/
							//os_policy << source_domain_pre << endl;	
						} 
						if(regex_search(source_m,what,m_tclass_pre_exp)){
							source_tclass_pre  = what[0];
							int length=strlen(source_tclass_pre.c_str());
							string blank_str="";
							source_tclass_pre=source_tclass_pre.replace(length - 1,1,blank_str);
							/*for debug*/
							//2.12ɮäѤꤳѤΤɬפä
							v_tmp_domain.push_back(source_domain_pre.c_str());
							//os_policy << source_tclass_pre << endl;	
						} 
						//changed here at segatex2.11
						if(regex_search(source_m,what,m_objclass_pre_exp)){
							source_objclass_pre  = what[0];
							int length=strlen(source_objclass_pre.c_str());
							string blank_str="";
							source_objclass_pre=source_objclass_pre.replace(0,1,blank_str);
							source_objclass_pre=source_objclass_pre.replace(length - 1,1,blank_str);
							/*for debug*/
							//os_policy << source_objclass_pre << endl;	
							//2.12ɮäѤꤳѤΤɬפä?
						        //v_matched_tmp_objclass.push_back(source_objclass_pre.c_str());
						} 
						if(regex_search(source_m,what,m_access_vector_exp)){
							source_access_vector_pre  = what[0];
							int length=strlen(source_access_vector_pre.c_str());
							string blank_str="";
							source_access_vector_pre=source_access_vector_pre.replace(length - 2,2,blank_str);
							source_access_vector_pre=source_access_vector_pre.replace(0,2,blank_str);
							/*for debug*/
							//os_policy << source_access_vector_pre << endl;	
						} 
						if(regex_search(source_m,what,m_interface_pre_exp)){
							source_interface_pre  = what[0];
							/*for debug*/
							//os_policy << source_interface_pre << endl;	
							/*end for debug*/
							//ok,ǡhttpd_t:file Ǥ
							if(source_interface_pre != source_interface_pre_prev){
								v_source_interface_pre.push_back(source_interface_pre.c_str());
								source_interface_pre_prev  = what[0];
							}
						} 
						/*ޥåΤޤᡢmultimapɤ߹ǤǼФ򤹤*/
						pattern_matched.insert(pair<string, string>(source_interface_pre,source_domain_pre));
						pattern_not_matched.insert(pair<string, string>(source_interface_pre,source_macro));
						pattern_not_matched_objclass.insert(pair<string, string>(source_interface_pre,source_objclass_pre));
						//forgot to check this...segatex2.11
						//os_policy << "<" << source_objclass_pre << ":" << source_access_vector_pre << ">" << endl;
						pattern_not_matched_access_vector.insert(pair<string, string>(source_objclass_pre,source_access_vector_pre));
						pattern_not_matched_domain.insert(pair<string, string>(source_interface_pre,source_domain_pre));
						pattern_not_matched_tclass.insert(pair<string, string>(source_interface_pre,source_tclass_pre));
						source_macro_numbers++;
					}
					int interface_numbers=0;
					//string was_not_matched = " was not matched !";
					string source_interface_pre_comp="";
					for(p_source_interface_pre=v_source_interface_pre.begin(); p_source_interface_pre < v_source_interface_pre.end(); p_source_interface_pre++){
						//ʸϡsource_interface_pre ʤ㡧httpd_t:file
						string source_interface_pre = *p_source_interface_pre;
						//os_policy << "source_interface_pre:" << source_interface_pre << endl;
						//const char* m_interface_accv = ":(.*)\\{(.*)\\}";
						const char* m_interface_accv_pre = ":(.*)\\}";
						const char* m_interface_accv = "(:[a-zA-Z0-9_]*)[[:space:]]";
						//segatex2.12ɮ
						const char* m_auth_domtrans = "auth_domtrans";
						const char* m_bin_domtrans = "bin_domtrans";
						const char* m_cifs_domtrans = "cifs_domtrans";
						const char* m_nfs_domtrans = "nfs_domtrans";
						const char* m_sbin_domtrans = "sbin_domtrans";
						const char* m_shell_domtrans = "shell_domtrans";
						const char* m_spec_domtrans = "spec_domtrans";
						const char* m_boot_filetrans = "boot_filetrans";
						const char* m_etc_filetrans = "etc_filetrans";
						const char* m_home_filetrans = "home_filetrans";
						const char* m_kernel_modules_filetrans = "kernel_modules_filetrans";
						const char* m_lock_filetrans = "lock_filetrans";
						const char* m_pid_filetrans = "pid_filetrans";
						const char* m_usr_filetrans = "usr_filetrans";
						const char* m_tmp_filetrans = "tmp_filetrans";
						const char* m_var_filetrans = "var_filetrans";
						const char* m_var_lib_filetrans = "var_lib_filetrans";
						const char* m_tmpfs_filetrans = "tmpfs_filetrans";
						const char* m_log_filetrans = "log_filetrans";
						const char* m_spool_filetrans = "spool_filetrans";
						const char* m_home_dir_filetrans = "userdom_generic_user_home_dir_filetrans_generic_user_home_content";
						const char* m_sysadm_home_dir_filetrans = "userdom_sysadm_home_dir_filetrans";
						const char* m_create_pty = "create_pty";
						const char* m_cron_system_entry = "cron_system_entry";
						const char* m_kernel_sendrecv_unlabeled_association = "kernel_sendrecv_unlabeled_association";
						regex m_interface_accv_exp(m_interface_accv);
						regex m_interface_accv_pre_exp(m_interface_accv_pre);
						regex m_auth_domtrans_exp(m_auth_domtrans);
						regex m_bin_domtrans_exp(m_bin_domtrans);
						regex m_cifs_domtrans_exp(m_cifs_domtrans);
						regex m_nfs_domtrans_exp(m_nfs_domtrans);
						regex m_sbin_domtrans_exp(m_sbin_domtrans);
						regex m_shell_domtrans_exp(m_shell_domtrans);
						regex m_spec_domtrans_exp(m_spec_domtrans);
						regex m_boot_filetrans_exp(m_boot_filetrans);
						regex m_etc_filetrans_exp(m_etc_filetrans);
						regex m_home_filetrans_exp(m_home_filetrans);
						regex m_kernel_modules_filetrans_exp(m_kernel_modules_filetrans);
						regex m_lock_filetrans_exp(m_lock_filetrans);
						regex m_pid_filetrans_exp(m_pid_filetrans);
						regex m_tmp_filetrans_exp(m_tmp_filetrans);
						regex m_usr_filetrans_exp(m_usr_filetrans);
						regex m_var_filetrans_exp(m_var_filetrans);
						regex m_var_lib_filetrans_exp(m_var_lib_filetrans);
						regex m_tmpfs_filetrans_exp(m_tmpfs_filetrans);
						regex m_log_filetrans_exp(m_log_filetrans);
						regex m_spool_filetrans_exp(m_spool_filetrans);
						regex m_home_dir_filetrans_exp(m_home_dir_filetrans);
						regex m_sysadm_home_dir_filetrans_exp(m_sysadm_home_dir_filetrans);
						regex m_create_pty_exp(m_create_pty);
						regex m_cron_system_entry_exp(m_cron_system_entry);
						regex m_kernel_sendrecv_unlabeled_association_exp(m_kernel_sendrecv_unlabeled_association);
						string source_interface_accv_pre;
						string source_interface_accv;
						string packet_str="packet";
						string send_str="send";
						string recv_str="recv";
															string pair_process="process";
															string paired_transition="transition";
															string paired_siginh="siginh";
															string paired_rlimitinh="rlimitinh";
															string paired_noatsecure="noatsecure";

															string pair_association="association";
															string paired_sendto="sendto";
															string paired_recvfrom="recvfrom";

															string pair_packet="packet";
															string paired_send="send";
															string paired_recv="recv";

															string pair_netif="netif";
															string paired_tcp_send="tcp_send";
															string paired_tcp_recv="tcp_recv";
															string paired_udp_send="udp_send";
															string paired_udp_recv="udp_recv";

															string pair_node="node";

															string pair_tcp_socket="tcp_socket";
															string paired_send_msg="send_msg";
															string paired_recv_msg="recv_msg";
															string paired_node_bind="node_bind";
															string paired_name_bind="name_bind";
															string paired_name_connect="name_connect";

															string pair_udp_socket="udp_socket";

															string pair_capability="capability";
															string paired_net_bind_service="net_bind_service";

															string pair_security="security";
															string paired_setbool="setbool";
															string paired_setenforce="setenforce";

						cmatch what;
						string blank_str = " ";
						regex re("[a-zA-Z0-9_]*,");
						string plus_source_interface_pre = blank_str + source_interface_pre;
						//os_policy << "plus_source_interface_pre:" << plus_source_interface_pre << endl;
						const char* m_engine = plus_source_interface_pre.c_str();
						regex m_interface_engine_exp(m_engine);
						/*read the engine and check*/
						/*󥸥ե夫鸡롣forפСޥåƤ*/
						for(p_engine=v_engine.begin(); p_engine < v_engine.end(); p_engine++){
							string source_macro_engine = *p_engine;
							const char* source_m_engine = source_macro_engine.c_str();
							//ʸ󤫤Ǥregexϡm_interface_engine_exp ʤ㡧httpd_t:file
							if(regex_search(source_m_engine,what,m_interface_engine_exp)){
								source_interface_engine  = what[0];
								//segatex2.05ɮ꤬狼ätmp_t:fileȤĤxxx_tmp_t:fileˤääƤޤΤǤ롣ȤȤǡΤ褦ˡϤ˶դƸƤߤ
								//os_policy << source_interface_pre << " matched !!" << endl;
								
								/*interface all sentence*/
								//os_policy << source_macro_engine << endl;
								/*end interface all sentence*/
								/*Ǥϡޥå祤󥿥եobjectclassΥ٥ޥޥåפѤ*/
								if(regex_search(source_m_engine,what,m_interface_accv_pre_exp)){
									source_interface_accv_pre  = what[0];
									const char* source_interface_accv_pre_str = source_interface_accv_pre.c_str();
									//os_policy << source_interface_accv_pre << endl;
									if(regex_search(source_interface_accv_pre_str,what,m_interface_accv_exp)){
										source_interface_accv  = what[0];
										int length=strlen(source_interface_accv.c_str());
										string blank_str="";
										source_interface_accv=source_interface_accv.replace(length,1,blank_str);
										source_interface_accv=source_interface_accv.replace(0,1,blank_str);
										//os_policy << source_interface_accv << endl;
										//v_matched_objclass_accv.push_back(source_interface_accv.c_str());
									}
									int length=strlen(source_interface_accv_pre.c_str());
									string blank_str="";
									string bracket_first_str="{";
									source_interface_accv_pre=source_interface_accv_pre.replace(length -1,1,blank_str);
									int bracket_first_position=source_interface_accv_pre.find_first_of(bracket_first_str);
									source_interface_accv_pre=source_interface_accv_pre.replace(0,bracket_first_position + 1,blank_str);
									//os_policy << source_interface_accv_pre << endl;
									regex tmp_re("[[:space:]]([^[:space:]]*)[a-zA-Z0-9_]*");
									string::const_iterator it=source_interface_accv_pre.begin(), end=source_interface_accv_pre.end();
									while(it != end){
										smatch result;
										if( !regex_search(it, end, result, tmp_re)){
											break;
										}
										if(result.str() !=" "){
											pattern_matched_access_vector.insert(pair<string, string>(source_interface_accv,result.str()));
											//os_policy << "interface_core<" << source_interface_accv << ":" << result.str() << ">" << endl;
										}
										it = result[0].second;
									}
								}
								/*󥿥եλobjectclassΥ٥ѤߤϤޤ*/
								//2.12ɮ󥿥ե򸡺
								if(regex_search( source_macro_engine, re )){
									string::const_iterator it=source_macro_engine.begin(), end=source_macro_engine.end();
									int i=0;
									string check_str = ":";
									string bracket_first_str = "(";
									string bracket_last_str = ")";
									string comma_str = ",";
									string private_type = "file";
									while( it != end){
										//ޥåսƬ
										smatch result;
										if( !regex_search(it, end, result, re)){
											break;
										}
										//os_policy << result.str() << endl;
										it = result[0].second;
										if(i==2){
											//ǡhttpd_t:file multimap餵ơdomainѴmatchedΥ٥ѤȤǤꡣ
											//Ȥä顢interfaceϤäȹΤǡinterfaceȤ٥Ѥǡ⤦󥨥󥸥ˤobjectclass,access_vectorФɬפä
											int length=strlen(result.str().c_str());
											//2.03ɮʬʶԤΤɤ
											if(length >1){
												string blank_str="";
												string interface_raw_str=result.str().replace(length -1,1,blank_str);
												//ǥ󥿥եȤƤ
												v_interface_raw.push_back(interface_raw_str.c_str());
												//os_policy << interface_raw_str << ":" <<endl;
												p_pattern_not_matched_domain=pattern_not_matched_domain.find(source_interface_pre);
												if(p_pattern_not_matched_domain != pattern_not_matched_domain.end()){
													do{
														int length=strlen(result.str().c_str());
														string blank_str="";
														string result_str=result.str().replace(length -1,1,blank_str);
														string domain_dollar_1;
														string domain_dollar_2;
														string domain_interface_echo;
														domain_dollar_1=p_pattern_not_matched_domain->second;
														//2.12ɮ
														//륤󥿥եϡ򣲤ɬפȤ롣domtransξ
														cmatch what;
														if((regex_search(result_str.c_str(),what,m_auth_domtrans_exp))||
														(regex_search(result_str.c_str(),what,m_bin_domtrans_exp))||
														(regex_search(result_str.c_str(),what,m_cifs_domtrans_exp))||
														(regex_search(result_str.c_str(),what,m_nfs_domtrans_exp))||
														(regex_search(result_str.c_str(),what,m_sbin_domtrans_exp))||
														(regex_search(result_str.c_str(),what,m_shell_domtrans_exp))||
														(regex_search(result_str.c_str(),what,m_spec_domtrans_exp))
														){
															string domtransed="_domtransed_t";
															//os_policy << "oohps !" << endl;
															domain_dollar_2=p_pattern_not_matched_domain->second;
															int length=strlen(domain_dollar_2.c_str());
															domain_dollar_2=domain_dollar_2.replace(length -2,2,blank_str);
															domain_dollar_2= domain_dollar_2 + domtransed;
											
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															//¤ʤʤΤƤΤǡŪѤǤ
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_process,paired_transition));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_process,paired_siginh));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_process,paired_rlimitinh));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_process,paired_noatsecure));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_association,paired_sendto));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_association,paired_recvfrom));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_packet,paired_sendto));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_packet,paired_recvfrom));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_packet,paired_send));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_packet,paired_recv));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_netif,paired_sendto));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_netif,paired_recvfrom));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_netif,paired_tcp_send));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_netif,paired_tcp_recv));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_netif,paired_udp_send));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_netif,paired_udp_recv));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_node,paired_tcp_send));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_node,paired_tcp_recv));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_node,paired_udp_send));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_node,paired_udp_recv));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_tcp_socket,paired_send_msg));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_tcp_socket,paired_recv_msg));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_tcp_socket,paired_node_bind));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_tcp_socket,paired_name_bind));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_tcp_socket,paired_name_connect));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_udp_socket,paired_send_msg));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_udp_socket,paired_recv_msg));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_udp_socket,paired_node_bind));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_udp_socket,paired_name_bind));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_udp_socket,paired_node_bind));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_capability,paired_net_bind_service));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_security,paired_setbool));
															pattern_not_matched_access_vector.insert(pair<string, string>(pair_security,paired_setenforce));
															//ѤǤɬפΤ
						        								v_matched_tmp_objclass.push_back(pair_process.c_str());
						        								v_matched_tmp_objclass.push_back(pair_association.c_str());
						        								v_matched_tmp_objclass.push_back(pair_packet.c_str());
						        								v_matched_tmp_objclass.push_back(pair_netif.c_str());
						        								v_matched_tmp_objclass.push_back(pair_node.c_str());
						        								v_matched_tmp_objclass.push_back(pair_tcp_socket.c_str());
						        								v_matched_tmp_objclass.push_back(pair_udp_socket.c_str());
						        								v_matched_tmp_objclass.push_back(pair_capability.c_str());
						        								v_matched_tmp_objclass.push_back(pair_security.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + bracket_last_str;  
														//boot_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_boot_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															//segatex2.15 again changed
															domain_dollar_2="boot_runtime_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//etc_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_etc_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="etc_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//home_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_home_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="home_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//kernel_modules_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_kernel_modules_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="kernel_modules_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//lock_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_lock_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="lock_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//pid_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_pid_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="pid_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//usr_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_usr_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="usr_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//tmp_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_tmp_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															string tmp_filetrans_echo="tmp_t";
															domain_dollar_2=p_pattern_not_matched_domain->second;
															int length=strlen(domain_dollar_2.c_str());
															domain_dollar_2=domain_dollar_2.replace(length -1,2,blank_str);
															domain_dollar_2= domain_dollar_2 + tmp_filetrans_echo;
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//var_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_var_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="var_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//var_lib_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_var_lib_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="var_lib_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//tmpfs_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_tmpfs_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="tmpfs_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//log_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_log_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="log_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//spool_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_spool_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="spool_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//home_dir_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_home_dir_filetrans_exp)){
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + private_type + bracket_last_str;  
														//sysadm_home_dir_filetransξ
														}else if(regex_search(result_str.c_str(),what,m_sysadm_home_dir_filetrans_exp)){
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															domain_dollar_2="sysadm_home_dir_tmp_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + comma_str + private_type + bracket_last_str;  
														//create_ptyξ
														}else if(regex_search(result_str.c_str(),what,m_create_pty_exp)){
															//os_policy << "oohps !" << endl;
															string filetransed="_pty_t";
															domain_dollar_2=p_pattern_not_matched_domain->second;
															int length=strlen(domain_dollar_2.c_str());
															domain_dollar_2=domain_dollar_2.replace(length -2,2,blank_str);
															domain_dollar_2= domain_dollar_2 + filetransed;
															//ܺѤߥɥᥤѤǤǥå󥳤type ... ;ȤƽФ򤹤
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + bracket_last_str;  
														//üʾ
														}else if(regex_search(result_str.c_str(),what,m_cron_system_entry_exp)){
															domain_dollar_2="anacron_exec_t";
															v_dollar_2_domain.push_back(domain_dollar_2.c_str());
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + comma_str + domain_dollar_2 + bracket_last_str;  
														//kernel_sendrecv_unlabeled_association
														}else if(regex_search(result_str.c_str(),what,m_kernel_sendrecv_unlabeled_association_exp)){
														//os_policy << "oohps !" << endl;
														//multimapȥ٥ξѤǤɬפ
														pattern_not_matched_access_vector.insert(pair<string, string>(packet_str,send_str));
														pattern_not_matched_access_vector.insert(pair<string, string>(packet_str,recv_str));
														v_matched_tmp_objclass.push_back(packet_str.c_str());
														pattern_not_matched_access_vector.insert(pair<string, string>(pair_tcp_socket,paired_node_bind));
														v_matched_tmp_objclass.push_back(pair_tcp_socket.c_str());
														pattern_not_matched_access_vector.insert(pair<string, string>(pair_udp_socket,paired_node_bind));
														v_matched_tmp_objclass.push_back(pair_udp_socket.c_str());
														}else{
															domain_interface_echo = result_str + bracket_first_str + domain_dollar_1 + bracket_last_str;  
														}
														//ǥ󥿥ե(ɥᥤ)ѤǤ
														//segatex2.12ɮȯdomtrans󥿥եξν֤ɤ뤫
														v_domain_interface.push_back(domain_interface_echo.c_str());
														//os_policy << domain_interface_echo << endl;
														p_pattern_not_matched_domain++;
													}while(p_pattern_not_matched_domain != pattern_not_matched_domain.upper_bound(source_interface_pre));
												}
											}
											//pattern_matched_tclassobjclass_interface.insert(pair<string, string>(source_interface_pre,result.str()));
										}
										//os_policy << i << endl;
										i++;
									}
									interface_numbers++;
						//			os_policy << interface_numbers << endl;
								}
							}
							/*ޥåȤobjclass typeФˡ롣*/
							/*ǤޤȤơ٥ƥʤѤǤ夫饽ȥˡƽФ*/
							if(source_interface_pre_comp != source_interface_pre){
								p_pattern_not_matched_objclass=pattern_not_matched_objclass.find(source_interface_pre);
								if(p_pattern_not_matched_objclass != pattern_not_matched_objclass.end()){
									do{
										//os_policy << "matchobjclass:" << p_pattern_not_matched_objclass->second << ";" << endl;
										v_matched_tmp_objclass.push_back(p_pattern_not_matched_objclass->second.c_str());
										p_pattern_not_matched_objclass++;
									}while(p_pattern_not_matched_objclass != pattern_not_matched_objclass.upper_bound(source_interface_pre));
								}
								p_pattern_not_matched_domain=pattern_not_matched_domain.find(source_interface_pre);
								if(p_pattern_not_matched_domain != pattern_not_matched_domain.end()){
									do{
										//os_policy << p_pattern_not_matched_domain->second << endl;
										v_matched_tmp_domain.push_back(p_pattern_not_matched_domain->second.c_str());
										p_pattern_not_matched_domain++;
									}while(p_pattern_not_matched_domain != pattern_not_matched_domain.upper_bound(source_interface_pre));
								}
								p_pattern_not_matched_tclass=pattern_not_matched_tclass.find(source_interface_pre);
								if(p_pattern_not_matched_tclass != pattern_not_matched_tclass.end()){
									do{
										//os_policy << p_pattern_not_matched_tclass->second << endl;
										v_matched_tmp_domain.push_back(p_pattern_not_matched_tclass->second.c_str());
										p_pattern_not_matched_tclass++;
									}while(p_pattern_not_matched_tclass != pattern_not_matched_tclass.upper_bound(source_interface_pre));
								}
							}
							source_interface_pre_comp = source_interface_pre;
						}
						//ޥåʤäȤεߺѺǡallowʸФ٤ν
						//os_policy << source_interface_pre ;
						//os_policy << " was_not_matched !!!!!!!!"<< endl;
						/*ޥåʤäۤϡǤޤȤơ٥ƥʤѤǤ夫饽ȥˡƽФ*/	
						p_pattern_not_matched_objclass=pattern_not_matched_objclass.find(source_interface_pre);
						if(p_pattern_not_matched_objclass != pattern_not_matched_objclass.end()){
							do{
								//os_policy << "matcheʤäobjclass:" << p_pattern_not_matched_objclass->second << ";" << endl;
								// 2ܤϡ826(old description)
								v_tmp_objclass.push_back(p_pattern_not_matched_objclass->second.c_str());
								p_pattern_not_matched_objclass++;
							}while(p_pattern_not_matched_objclass != pattern_not_matched_objclass.upper_bound(source_interface_pre));
						}
						p_pattern_not_matched_domain=pattern_not_matched_domain.find(source_interface_pre);
						if(p_pattern_not_matched_domain != pattern_not_matched_domain.end()){
							do{
						//		os_policy << p_pattern_not_matched_domain->second << endl;
								v_tmp_domain.push_back(p_pattern_not_matched_domain->second.c_str());
								p_pattern_not_matched_domain++;
							}while(p_pattern_not_matched_domain != pattern_not_matched_domain.upper_bound(source_interface_pre));
						}
						p_pattern_not_matched_tclass=pattern_not_matched_tclass.find(source_interface_pre);
						if(p_pattern_not_matched_tclass != pattern_not_matched_tclass.end()){
							do{
						//		os_policy << p_pattern_not_matched_tclass->second << endl;
								v_tmp_domain.push_back(p_pattern_not_matched_tclass->second.c_str());
								p_pattern_not_matched_tclass++;
							}while(p_pattern_not_matched_tclass != pattern_not_matched_tclass.upper_bound(source_interface_pre));
						}
					}
					/*end read the engine agin and check...*/
					sort(v_interface_raw.begin(),v_interface_raw.end());
					p_interface_raw_end=unique(v_interface_raw.begin(),v_interface_raw.end());

					/*2ܤθꤳܤʬȤ󥿥եäƤ*/
					/*segatex2.04ɮʬengine򿷤ĤäƤ鸡Τ*/
					vector<string> v_engine_selected;
					vector<string>::iterator p_engine_selected, p_engine_selected_end;
					for(p_interface_raw=v_interface_raw.begin(); p_interface_raw < v_interface_raw.end(); p_interface_raw++){
						string source_interface_raw = *p_interface_raw;
						//os_policy << source_interface_raw << endl;
						const char* m_source_interface_raw = source_interface_raw.c_str();
						regex m_source_interface_raw_exp(m_source_interface_raw);
						for(p_engine=v_engine.begin(); p_engine < v_engine.end(); p_engine++){
							string source_engine_original = *p_engine;
							const char* source_engine_original_str = source_engine_original.c_str();
							cmatch what;
							if(regex_search(source_engine_original_str,what,m_source_interface_raw_exp)){
								v_engine_selected.push_back(source_engine_original.c_str());
							}
						}
					}
					sort(v_engine_selected.begin(),v_engine_selected.end());
					p_engine_selected_end=unique(v_engine_selected.begin(),v_engine_selected.end());


					/*end read the engine agin and check...*/
					/*2ܤθꤳܤʬȤ󥿥եäƤ*/
					/*ϵդʤȡФƤ뤫狼ʤޤ󥸥󤬤ܤȤäƤޤФޤǤ*/



					const char* m_domain_interface_h = "[a-zA-Z][a-zA-Z0-9_.]*_t:";
					const char* m_domain_interface_h_204 = "allow(.*)_t";
					const char* m_domain_interface_h_204_2 = "[[:space:]][a-zA-Z][a-zA-Z0-9_.]*_t";
					const char* m_objclass_interface_h = ":.*?\\{";
					const char* m_objclass_interface_h_dash = ":[a-zA-Z0-9_]*";
					const char* m_objclass_interface_h2 = ":(.*)([^[:space:]*])[[:space:]]";
					//ǡ{{}}ȤΤȤʤ褦ˤʤ̵äݤΤǡǤ뤫
					//segatex2.05ɮʾ嵭ؤˤʤäƤ
					const char* m_accv_interface_h = "\\{(.*)\\}";
					const char* m_accv_interface_h_special = "\\{(.*)\\}:";
					const char* m_accv_interface_h2 = "[[:space:]][a-zA-Z0-9_]*;,";
					string blank_str="";
					string space_str=" ";
					string tiruda_str="~";
					regex m_domain_interface_h_exp(m_domain_interface_h);
					regex m_domain_interface_h_204_exp(m_domain_interface_h_204);
					regex m_domain_interface_h_204_2_exp(m_domain_interface_h_204_2);
					regex m_objclass_interface_h_exp(m_objclass_interface_h);
					regex m_objclass_interface_h_dash_exp(m_objclass_interface_h_dash);
					regex m_objclass_interface_h2_exp(m_objclass_interface_h2);
					regex m_accv_interface_h_exp(m_accv_interface_h);
					regex m_accv_interface_h_special_exp(m_accv_interface_h_special);
					regex m_accv_interface_h2_exp(m_accv_interface_h2);
					//read the engine and check
					//󥸥ե夫鸡롣forפСޥåƤ
					//⤦󡢼ꤳܤobjectclass򸡺
					string domain_interface_h;
					string domain_interface_h_204_2;
					string objclass_interface_h;
					string objclass_interface_h2;
					string accv_interface_h;
					string accv_interface_h2;
					//Ѥߥ󥸥󥸥򸡺
	//int v_engine_size=v_engine.size();
	//os_policy << v_engine_size << endl;
					//2.04ɮʬΤؤ
					//2.05ǤϡselfȤobjclassɤ뤫ˤʤޤ...(segatex2.05ɮ(ȤʤΤʤ))...
					for(p_engine_selected=v_engine_selected.begin(); p_engine_selected < v_engine_selected.end(); p_engine_selected++){
						string source_engine = *p_engine_selected;
						const char* source_engine_str = source_engine.c_str();
						cmatch what;
						//os_policy << source_engine << endl;
						
						//Ϻٹɬ
						if(regex_search(source_engine_str,what,m_domain_interface_h_204_exp)){
							domain_interface_h = what[0];
							const char* domain_interface_h_str = domain_interface_h.c_str();
							//os_policy << source_engine << endl;
							//os_policy << domain_interface_h << endl;
							if(regex_search(domain_interface_h_str,what,m_domain_interface_h_204_2_exp)){
								domain_interface_h_204_2 = what[0];
								//os_policy << source_engine << endl;
								//os_policy << domain_interface_h << endl;
								domain_interface_h_204_2=domain_interface_h_204_2.replace(0,1,blank_str);
								//domainѤǤ
								//Ǥϡv_matched_tmp_domainѤࡣ
								v_matched_tmp_domain.push_back(domain_interface_h_204_2.c_str());
								//os_policy << domain_interface_h_204_2 << endl;	
							}
							////////int length=strlen(domain_interface_h.c_str());
							////////domain_interface_h=domain_interface_h.replace(length-1,1,blank_str);
							//domainѤǤ
							//Ǥϡv_matched_tmp_domainѤࡣ
							//v_matched_tmp_domain.push_back(domain_interface_h.c_str());
							//os_policy << domain_interface_h << endl;	
						}
						if(regex_search(source_engine_str,what,m_objclass_interface_h_exp)){
							objclass_interface_h = what[0];
							const char* objclass_interface_h_cstr=objclass_interface_h.c_str();
							if(regex_search(objclass_interface_h_cstr,what,m_objclass_interface_h_dash_exp)){
								objclass_interface_h = what[0];
							}
							//os_policy << objclass_interface_h << endl;
							//added in segatex2.11
							string colon=":";
							if(objclass_interface_h != colon){
								objclass_interface_h=objclass_interface_h.replace(0,1,blank_str);
								//os_policy << "objclass_interface_h:" << objclass_interface_h << ":" << endl;
								//v_tmp_objclassϡ¤ϸΥȤʤΤǡ֤줿(󥿥եäƤ)
								//objclassѤǤʤȥᡣ
								//Ǥϡv_matched_tmp_objclassѤߡȤv_tmp_objclass˲ä
								//added if clause segatex2.11
								v_matched_tmp_objclass.push_back(objclass_interface_h.c_str());
								objclass_interface_h = objclass_interface_h + space_str ;
							}
						}else{
							//С2.03ɮʬʡelseˤƤʤäΤǡѤʻˤʤäƤ...
							//С2.02ɮʬʥ٥{}ǰϤޤƤ櫓Ǥ̵
							if(regex_search(source_engine_str,what,m_objclass_interface_h2_exp)){
								objclass_interface_h2 = what[0];
								objclass_interface_h2=objclass_interface_h2.replace(0,1,blank_str);
								int length=strlen(objclass_interface_h2.c_str());
								objclass_interface_h2=objclass_interface_h2.replace(length-1,1,blank_str);
								//os_policy << "objclasss_interface_h2" << objclass_interface_h2 << ":" << endl;	
								//v_tmp_objclassϡ¤ϸΥȤʤΤǡ֤줿(󥿥եäƤ)
								//objclassѤǤʤȥᡣ
								//Ǥϡv_matched_tmp_objclassѤߡȤv_tmp_objclass˲ä
								v_matched_tmp_objclass.push_back(objclass_interface_h2.c_str());
								objclass_interface_h2 = objclass_interface_h2 + space_str ;
							}
						}
						//segatex2.05ɮޤåƤ顢ѤळȤˤޤ
						if(regex_search(source_engine_str,what,m_accv_interface_h_special_exp)){
										//ѤʤΤѤޤʤ
						}else{
							if(regex_search(source_engine_str,what,m_accv_interface_h_exp)){
								//
								accv_interface_h = what[0];
								accv_interface_h=accv_interface_h.replace(0,1,blank_str);
								int length=strlen(accv_interface_h.c_str());
								accv_interface_h=accv_interface_h.replace(length -1,1,blank_str);
								//added in seagtex2.11{}ʧ
								int bracket_first_position=-1;
								int bracket_last_position=-1;
								bracket_first_position=accv_interface_h.find("{");
								if(bracket_first_position != -1){
									//os_policy << bracket_first_position << "found bracket_first_str !!" << endl;	
									accv_interface_h=accv_interface_h.replace(bracket_first_position,2,blank_str);
								}
								bracket_last_position=accv_interface_h.find("}");
								if(bracket_last_position != -1){
									//os_policy << bracket_last_position << "found bracket_last_str !!" << endl;	
									accv_interface_h=accv_interface_h.replace(bracket_last_position,2,blank_str);
								}
								//os_policy << accv_interface_h << endl;	

								//segatex2.05ɮʤ󡢤ޤʡ
								regex tmp_re("[[:space:]]([^[:space:]]*)[a-zA-Z0-9_]*");
								regex tmp_re2("[[:space:]][a-zA-Z0-9_.]*_t");
								string::const_iterator it=accv_interface_h.begin(), end=accv_interface_h.end();
								while(it != end-1){
									smatch result;
									if( !regex_search(it, end, result, tmp_re)){
										break;
									}
									if((result.str() != " {")&&(result.str() != " }")){
										const char* result_str_cstr = result.str().c_str();
										if(regex_search(result_str_cstr,what,tmp_re2)){
											//ѤʤΤѤޤʤ
										}else{
											pattern_matched_access_vector.insert(pair<string, string>(objclass_interface_h,result.str()));
											//segatex2.05ɮʤǤǤѤʤΤĤޤƤޤ˾Ǥ͡
											//os_policy << "interface<" <<objclass_interface_h << ":" << result.str() << ">" << endl;
										}
									}

									//os_policy << "interfaceäƤobjclass:" << objclass_interface_h << ";"<< endl;
									v_matched_tmp_objclass.push_back(objclass_interface_h.c_str());
									it = result[0].second;
								}
							}
						}
						//С2.02ɮʬʥ٥{}ǰϤޤƤ櫓Ǥ̵
						if(regex_search(source_engine_str,what,m_accv_interface_h2_exp)){
							accv_interface_h2 = what[0];
							int length=strlen(accv_interface_h2.c_str());
							accv_interface_h2=accv_interface_h2.replace(length -2,2,blank_str);
							//os_policy << accv_interface_h2 << endl;
							//os_policy << "interface2<" <<objclass_interface_h2 << ":" << accv_interface_h2 << ">" << endl;
							pattern_matched_access_vector.insert(pair<string, string>(objclass_interface_h2,accv_interface_h2));
						}
					}
					is.close();

					/*class νϡ٥ޤȤ뤿˽򤷤ƤФ*/
					/*̤Ƥtmp_strǡpattern_not_matched_access_vectorȤmultimap򸡺*/
					/*tmp_strmultimap裲°äС٥*/
					/*tmp_str˲äС}ԤäơƤ*/
					/*κݡ󥿥ե˥ޥåΤޤȤƤ*/
					/*ޤȤϡ󥿥եõʤäѿˡõΤѤǤǤ*/

					/*ޤʸǤobjclassޤȤ*/
					int v_matched_tmp_objclass_size=v_matched_tmp_objclass.size();
					for(int i=0;i < v_matched_tmp_objclass_size;i++){
						v_tmp_objclass.push_back(v_matched_tmp_objclass[i].c_str());
						string test = v_matched_tmp_objclass[i];
						//os_policy << "test:" << test << endl;
					}
					/*ˡ¦ǤmultimapޤȤ*/
					//2.12ɮ褦䡢ɤ߽ФȤ˰ĤʤΤɤ߽Фʤ
					/*multimapΥƥ졼Ȥä...*/
					//int test_size=pattern_not_matched_access_vector.size();
					//os_policy << "test_size:" << test_size << endl << endl;
					//int test_size3=pattern_matched_access_vector.size();
					//os_policy << "test_size3:" << test_size3 << endl << endl;
					p_pattern_matched_access_vector=pattern_matched_access_vector.begin();
					do{

						string objclass_matched_echo = p_pattern_matched_access_vector->first;
						string accv_matched_echo = p_pattern_matched_access_vector->second;
						//segatex2.05ʤǤΤȯϾɡ
						string blank_str="";
						string space_first_str=" ";
						int length=strlen(objclass_matched_echo.c_str());
						objclass_matched_echo=objclass_matched_echo.replace(length -1,1,blank_str);
						int space_first_position=accv_matched_echo.find_first_of(space_first_str);
						accv_matched_echo=accv_matched_echo.replace(0,space_first_position + 1,blank_str);
						//os_policy << "final<" << objclass_matched_echo << ":" << accv_matched_echo << ">" << endl;
						pattern_not_matched_access_vector.insert(pair<string, string>(objclass_matched_echo,accv_matched_echo));
						p_pattern_matched_access_vector++;
					}while(p_pattern_matched_access_vector != pattern_matched_access_vector.end());
					//int test_size2=pattern_not_matched_access_vector.size();
					//os_policy << "test_size2:" << test_size2 << endl << endl;

					sort(v_tmp_objclass.begin(),v_tmp_objclass.end());
					p_tmp_objclass_end=unique(v_tmp_objclass.begin(),v_tmp_objclass.end());

					os_policy << "####################################################" << endl;
					os_policy << "##### This file was generated by segatex3.02" << endl;
					os_policy << "####################################################" << endl;
					os_policy << "module my_policy_by_segatex 1.0.0;" << endl << endl;
					os_policy << "require {" << endl;
					string p_pattern_not_matched_objclass_pre=*v_tmp_objclass.begin();
					for(p_tmp_objclass=v_tmp_objclass.begin(); p_tmp_objclass < p_tmp_objclass_end; p_tmp_objclass++){
						string tmp_str= *p_tmp_objclass;
						string v_accv_pre_one_str="";
						string v_accv_pre_str="";
						//os_policy << "tmp_str:" << tmp_str << endl;
						/*ǤϡޥåʤäΤȡΤȡ󥿥եäƤobjclassaccess_vectorƳФƤ*/
						p_pattern_not_matched_access_vector=pattern_not_matched_access_vector.find(tmp_str);
						if(p_pattern_not_matched_access_vector != pattern_not_matched_access_vector.end()){
							os_policy << "	class " << p_pattern_not_matched_access_vector->first << " { " ;
							do{
										//2.12ɮfor debugǤƤȤȤϡ
										//os_policy << "second_check:" << p_pattern_not_matched_access_vector->second << endl;
								//2.12ɮĤʤ
								v_accv_pre_one_str=p_pattern_not_matched_access_vector->second;
								//os_policy << v_accv_pre_one_str << " ";
								//added in seagtex2.11{}ʧ
								int bracket_first_position=-1;
								int bracket_last_position=-1;
								bracket_first_position=v_accv_pre_one_str.find("{");
								if(bracket_first_position != -1){
									//os_policy << bracket_first_position << "found bracket_first_str !!" << endl;	
									v_accv_pre_one_str=v_accv_pre_one_str.replace(bracket_first_position,2,blank_str);
								}
								bracket_last_position=v_accv_pre_one_str.find("}");
								if(bracket_last_position != -1){
									//os_policy << bracket_last_position << "found bracket_last_str !!" << endl;	
									v_accv_pre_str=v_accv_pre_one_str.replace(bracket_last_position,2,blank_str);
								}
								//os_policy << v_accv_pre_one_str << " ";
								v_accv.push_back(v_accv_pre_one_str.c_str());
								if(p_pattern_not_matched_access_vector->first == p_pattern_not_matched_objclass_pre){
									/*Τʤ褦*/
									cmatch what;
									regex tmp_re3("(.*)\\$(.*)");
									if(regex_search(p_pattern_not_matched_access_vector->second.c_str(),what,tmp_re3)){
										/*⤷ʤ*/
										//string tmp_str;
										//tmp_str=what[0];
										//os_policy << "tmp_str:"<< tmp_str << endl;
									}else{
										v_accv_pre_str=p_pattern_not_matched_access_vector->second;
										//os_policy << v_accv_pre_str << " ";
										//added in seagtex2.11{}ʧ
										int bracket_first_position=-1;
										int bracket_last_position=-1;
										bracket_first_position=v_accv_pre_str.find("{");
										if(bracket_first_position != -1){
											//os_policy << bracket_first_position << "found bracket_first_str !!" << endl;	
											v_accv_pre_str=v_accv_pre_str.replace(bracket_first_position,2,blank_str);
										}
										bracket_last_position=v_accv_pre_str.find("}");
										if(bracket_last_position != -1){
											//os_policy << bracket_last_position << "found bracket_last_str !!" << endl;	
											v_accv_pre_str=v_accv_pre_str.replace(bracket_last_position,2,blank_str);
										}
										//os_policy << v_accv_pre_str << " ";
										v_accv.push_back(v_accv_pre_str.c_str());
									}
								}
								p_pattern_not_matched_objclass_pre = p_pattern_not_matched_access_vector->first;
								p_pattern_not_matched_access_vector++;
							}while(p_pattern_not_matched_access_vector != pattern_not_matched_access_vector.upper_bound(tmp_str));
							sort(v_accv.begin(),v_accv.end());
							p_accv_end=unique(v_accv.begin(),v_accv.end());
							for(p_accv=v_accv.begin(); p_accv < p_accv_end; p_accv++){
								string accv_str= *p_accv;
								os_policy << accv_str << " ";
							}
							os_policy << "};" << endl;
							v_accv.clear();
						}
					}

					/*type ϡdomaintclassޤȤƽФ*/
					/*κݡ󥿥ե˥ޥåΤȥޥåʤäΤޤȤƤ*/
					int v_matched_tmp_domain_size=v_matched_tmp_domain.size();
					for(int i=0;i < v_matched_tmp_domain_size;i++){
						v_tmp_domain.push_back(v_matched_tmp_domain[i].c_str());
						string test = v_matched_tmp_domain[i];
						//os_policy << test << endl;
					}
					//segatex2.12ɮ
					/*ˡܺѤߥɥᥤޤȤƤ*/
					int v_dollar_2_domain_size=v_dollar_2_domain.size();
					for(int i=0;i < v_dollar_2_domain_size;i++){
						v_tmp_domain.push_back(v_dollar_2_domain[i].c_str());
						string test = v_dollar_2_domain[i];
						//os_policy << test << endl;
					}
					sort(v_tmp_domain.begin(),v_tmp_domain.end());
					p_tmp_domain_end=unique(v_tmp_domain.begin(),v_tmp_domain.end());
					for(p_tmp_domain=v_tmp_domain.begin();p_tmp_domain < p_tmp_domain_end; p_tmp_domain++){
						string dom_str = *p_tmp_domain;
						os_policy << "	type " << dom_str << ";" << endl;
					}
					//roleФ
					sort(v_role.begin(),v_role.end());
					p_role_end=unique(v_role.begin(),v_role.end());
					for(p_role=v_role.begin(); p_role < p_role_end; p_role++){
						string role_tmp_str= *p_role;
						os_policy << "	role " << role_tmp_str << ";" << endl;
					}
					os_policy << "};" << endl << endl;
					/*ޥåʤäallowʸФ*/
					cmatch what;
					const char* m_snmfp = "(.*):([^[:space:]]*)([:space:])?";
					const char* m_acc_comp = "\\{(.*)\\}";
					regex m_snmfp_exp(m_snmfp);
					regex m_acc_comp_exp(m_acc_comp);
					//read the sentence and devide
					for(p2_v=v2.begin();p2_v < p2_v_end; p2_v++){
						string source_not_match_final_pre = *p2_v;
						const char* m_source_not_match_final_pre = source_not_match_final_pre.c_str();
						string allow_first  = what[0];
						string allow_last  = what[0];
						if(regex_search(m_source_not_match_final_pre,what,m_snmfp_exp)){
							allow_first  = what[0];
							v_allow_first.push_back(allow_first.c_str());
							//os_policy << allow_first << endl;
						if(regex_search(m_source_not_match_final_pre,what,m_acc_comp_exp)){
							allow_last  = what[0];
							int length=strlen(allow_last.c_str());
							string blank_str="";
							allow_last=allow_last.replace(length - 2,2,blank_str);
							allow_last=allow_last.replace(0,2,blank_str);
							//os_policy << allow_last << endl;
						}
							//ޥޥåפѤǤ
							pattern_allow_not_matched_echo.insert(pair<string, string>(allow_first,allow_last));
						}
					}
					/*allow backup_t sysadm_devpts_t:chr_fileȤv_allow_first򸵼ˡ
					pattern_allow_not_matched_echo򸡺
					ΤȤۤȤƱɽΤäȰ㤦
					*/
					sort(v_allow_first.begin(),v_allow_first.end());
					p_allow_first_end=unique(v_allow_first.begin(),v_allow_first.end());
					string p_allow_first_str=*v_allow_first.begin();
					for(p_allow_first=v_allow_first.begin(); p_allow_first < p_allow_first_end; p_allow_first++){
						string tmp_str= *p_allow_first;
						//os_policy << "tmp_str:" << tmp_str << endl;
						p_pattern_allow_not_matched_echo=pattern_allow_not_matched_echo.find(tmp_str);
						if(p_pattern_allow_not_matched_echo != pattern_allow_not_matched_echo.end()){
							//ո©ɡޤ
							os_policy << p_pattern_allow_not_matched_echo->first << " { " ;
							if(p_pattern_allow_not_matched_echo != pattern_allow_not_matched_echo.begin()){
								os_policy <<  p_pattern_allow_not_matched_echo->second.c_str() << " ";
							}
							//פƤС٥
							do{
								if(p_pattern_allow_not_matched_echo->first == p_allow_first_str){
									v_allow_last.push_back(p_pattern_allow_not_matched_echo->second.c_str());
								}
								p_allow_first_str = p_pattern_allow_not_matched_echo->first;
								p_pattern_allow_not_matched_echo++;
							}while(p_pattern_allow_not_matched_echo != pattern_allow_not_matched_echo.upper_bound(tmp_str));
							sort(v_allow_last.begin(),v_allow_last.end());
							p_allow_last_end=unique(v_allow_last.begin(),v_allow_last.end());
							for(p_allow_last=v_allow_last.begin(); p_allow_last < p_allow_last_end; p_allow_last++){
								string allow_last_str= *p_allow_last;
								os_policy << allow_last_str << " ";
							}
							os_policy << "};" << endl;
							v_allow_last.clear();
						}
					}
					//󥿥եФ
					sort(v_domain_interface.begin(),v_domain_interface.end());
					p_domain_interface_end=unique(v_domain_interface.begin(),v_domain_interface.end());
					for(p_domain_interface=v_domain_interface.begin(); p_domain_interface < p_domain_interface_end; p_domain_interface++){
						string domain_interface_echo_final = *p_domain_interface;	
						os_policy << domain_interface_echo_final << endl;
					}
					//when selpaw_interface.csv was existing and there are any denied log
					QFile file( filename_policy); // Read the text from a file
					if ( file.open( IO_ReadOnly ) ) {
						QTextStream stream( &file );
						textEdit1->setText( stream.read() );
					}
				}
				//end of !v.size()==0
			}
			os_policy.close();
		}
		//is.close();
		os_my_log.close();
	}
	is_engine.close();
	os_policy.close();
}
