/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.IImageSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YahooJpImageElement;
import slothLib.web.search.YahooJpImageSearchResult;

public class YahooJpImageSearch
implements IImageSearch {
    private static int MAX_NUM = 20;
    private String applicationID;
    private String baseRequestURL;
    private static String DEFAULT_URL = "http://search.yahooapis.jp/ImageSearchService/V2/imageSearch";
    private SearchType type;
    private int start;
    private SearchFormat format;
    private boolean adultOk;
    private Color coloration;
    private String[] site;
    private Proxy proxy;
    Map<String, Boolean> alreadyGotURL = new HashMap<String, Boolean>();

    public YahooJpImageSearch(String applicationID, String baseRequestURL) {
        this.applicationID = applicationID;
        this.baseRequestURL = baseRequestURL;
        this.type = SearchType.all;
        this.start = 1;
        this.format = SearchFormat.any;
        this.adultOk = false;
        this.coloration = Color.any;
        this.site = null;
    }

    public YahooJpImageSearch(String applicationID) {
        this(applicationID, DEFAULT_URL);
    }

    @Override
    public YahooJpImageSearchResult doSearch(String query, int maxNumber) throws WebSearchException {
        return this.doSearchOver(query, maxNumber);
    }

    public long getTotalNumber(String query) throws WebSearchException {
        return this.doSearch(query, 1).getTotalResultsAvailable();
    }

    public SearchType getType() {
        return this.type;
    }

    public void setType(SearchType value) {
        this.type = value;
    }

    public SearchFormat getFormat() {
        return this.format;
    }

    public void setFormat(SearchFormat value) {
        this.format = value;
    }

    public boolean getAdultOk() {
        return this.adultOk;
    }

    public void setAdultOk(boolean value) {
        this.adultOk = value;
    }

    public Color getColoration() {
        return this.coloration;
    }

    public void setColoration(Color value) {
        this.coloration = value;
    }

    public String[] getSite() {
        return this.site;
    }

    public void setSite(String[] value) {
        this.site = value;
    }

    public void setProxy(String proxyAddress) {
        this.proxy = proxyAddress == null ? null : PortUtil.createProxy(proxyAddress);
    }

    private YahooJpImageSearchResult doSearchOriginal(String query, int results, int start) throws WebSearchException {
        String requestURL = this.makeRequestURL(query, this.type, results, start, this.format, this.adultOk, this.coloration, this.site);
        Document xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
        Element xmlRoot = xmlDoc.getDocumentElement();
        long totalResultsAvailable = Long.parseLong(xmlRoot.getAttribute("totalResultsAvailable"));
        int totalResultsReturned = Integer.parseInt(xmlRoot.getAttribute("totalResultsReturned"));
        int firstResultPosition = Integer.parseInt(xmlRoot.getAttribute("firstResultPosition"));
        ArrayList<YahooJpImageElement> resultElementList = new ArrayList<YahooJpImageElement>();
        NodeList xmlResultList = xmlRoot.getElementsByTagName("Result");
        int rank = start - 1;
        String firstURL = this.getElementString(((Element)xmlResultList.item(0)).getElementsByTagName("Url"));
        if (this.alreadyGotURL.containsKey(firstURL)) {
            return new YahooJpImageSearchResult(query, 0L, 0, -1, new YahooJpImageElement[0]);
        }
        this.alreadyGotURL.put(firstURL, true);
        int i = 0;
        while (i < xmlResultList.getLength()) {
            Element xmlResult = (Element)xmlResultList.item(i);
            ++rank;
            String title = this.getElementString(xmlResult.getElementsByTagName("Title"));
            String summary = this.getElementString(xmlResult.getElementsByTagName("Summary"));
            String url = this.getElementString(xmlResult.getElementsByTagName("Url"));
            String clickUrl = this.getElementString(xmlResult.getElementsByTagName("ClickUrl"));
            String refererUrl = this.getElementString(xmlResult.getElementsByTagName("RefererUrl"));
            String fileSize = this.getElementString(xmlResult.getElementsByTagName("FileSize"));
            String fileFormat = this.getElementString(xmlResult.getElementsByTagName("FileFormat"));
            double height = Double.parseDouble(this.getElementString(xmlResult.getElementsByTagName("Height")));
            double width = Double.parseDouble(this.getElementString(xmlResult.getElementsByTagName("Width")));
            NodeList xmlThumbnailNode = xmlResult.getElementsByTagName("Thumbnail");
            String thumbnailUrl = "";
            double thumbnailHeight = 0.0;
            double thumbnailWidth = 0.0;
            if (xmlThumbnailNode != null) {
                int j = 0;
                while (j < xmlThumbnailNode.getLength()) {
                    Element xmlThumbnailElement = (Element)xmlThumbnailNode.item(j);
                    thumbnailUrl = this.getElementString(xmlThumbnailElement.getElementsByTagName("Url"));
                    thumbnailHeight = Double.parseDouble(this.getElementString(xmlThumbnailElement.getElementsByTagName("Height")));
                    thumbnailWidth = Double.parseDouble(this.getElementString(xmlThumbnailElement.getElementsByTagName("Width")));
                    ++j;
                }
            }
            String publisher = this.getElementString(xmlResult.getElementsByTagName("Publisher"));
            boolean frameOk = true;
            boolean inlineOk = true;
            if (xmlResult.hasAttribute("noframe")) {
                frameOk = false;
            }
            if (xmlResult.hasAttribute("noinline")) {
                inlineOk = false;
            }
            String copyright = this.getElementString(xmlResult.getElementsByTagName("Copyright"));
            YahooJpImageElement result = new YahooJpImageElement(rank, title, summary, url, clickUrl, refererUrl, fileSize, fileFormat, height, width, thumbnailUrl, thumbnailHeight, thumbnailWidth, publisher, frameOk, inlineOk, copyright);
            resultElementList.add(result);
            ++i;
        }
        return new YahooJpImageSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, resultElementList.toArray(new YahooJpImageElement[0]));
    }

    private YahooJpImageSearchResult doSearchOver(String query, int results) throws WebSearchException {
        YahooJpImageSearchResult r;
        int loop = (results - 1) / MAX_NUM;
        ArrayList<YahooJpImageElement> resultElementList = new ArrayList<YahooJpImageElement>();
        long totalResultsAvailable = 0L;
        int i = 0;
        while (i < loop) {
            r = this.doSearchOriginal(query, MAX_NUM, i * MAX_NUM + this.start);
            if (r.getFirstResultPosition() == -1) break;
            totalResultsAvailable = r.getTotalResultsAvailable();
            resultElementList.addAll(PortUtil.toList(r.getResultElements()));
            ++i;
        }
        r = this.doSearchOriginal(query, results - loop * MAX_NUM, loop * MAX_NUM + this.start);
        resultElementList.addAll(PortUtil.toList(r.getResultElements()));
        if (r.getFirstResultPosition() != -1) {
            totalResultsAvailable = r.getTotalResultsAvailable();
        }
        return new YahooJpImageSearchResult(query, totalResultsAvailable, resultElementList.size(), this.start, resultElementList.toArray(new YahooJpImageElement[0]));
    }

    private String getElementString(NodeList nodeList) {
        if (nodeList.getLength() == 0) {
            return "";
        }
        return nodeList.item(0).getTextContent();
    }

    private String makeRequestURL(String query, SearchType type, int results, int start, SearchFormat format, boolean adultOk, Color coloration, String[] site) {
        String strType = "";
        String strFormat = "";
        String strAdult = "";
        String strColoration = "";
        String strSite = "";
        switch (type) {
            case all: {
                break;
            }
            case any: {
                strType = "&type=any";
                break;
            }
            case phrase: {
                strType = "&type=phrase";
            }
        }
        switch (format) {
            case any: {
                break;
            }
            case bmp: {
                strFormat = "&format=bmp";
                break;
            }
            case gif: {
                strFormat = "&format=gif";
                break;
            }
            case jpeg: {
                strFormat = "&format=jpeg";
                break;
            }
            case png: {
                strFormat = "&format=png";
            }
        }
        if (adultOk) {
            strAdult = "&adulat_ok=1";
        }
        switch (coloration) {
            case any: {
                break;
            }
            case bw: {
                strColoration = "&coloration=bw";
                break;
            }
            case color: {
                strColoration = "&coloration=color";
            }
        }
        if (site != null) {
            if (site.length > 30) {
                throw new IllegalArgumentException("site\u306b\u6307\u5b9a\u3067\u304d\u308b\u30c9\u30e1\u30a4\u30f3\u306f30\u500b\u307e\u3067\u3067\u3059 site");
            }
            String[] stringArray = site;
            int n = site.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                strSite = String.valueOf(strSite) + "&site=" + s;
                ++n2;
            }
        }
        String uriString = String.valueOf(this.baseRequestURL) + "?appid=" + this.applicationID + "&query=" + query + strType + "&results=" + results + "&start=" + start + strFormat + strAdult + strColoration + strSite;
        String result = PortUtil.absoluteUri(uriString);
        return result;
    }

    public static enum Color {
        any,
        color,
        bw;

    }

    public static enum SearchFormat {
        any,
        bmp,
        gif,
        jpeg,
        png;

    }

    public static enum SearchType {
        all,
        any,
        phrase;

    }
}

