package test.org.seasar.framework.sel.boolexps;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.boolexps.InExp;
import org.seasar.framework.sel.exps.NullExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.util.ExpressionUtil;

public class InExpTest extends TestCase {

	public InExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		ObjectExp targetExp = new ObjectExp(new Integer(2));
		List inExpList = new ArrayList();
		inExpList.add(new ObjectExp(new Integer(1)));
		inExpList.add(new ObjectExp(new Integer(2)));
		inExpList.add(new ObjectExp(new Integer(3)));
		BoolExpression exp =
			new InExp(targetExp, ExpressionUtil.toExpressionArray(inExpList));
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		ObjectExp targetExp = new ObjectExp(new Integer(4));
		List inExpList = new ArrayList();
		inExpList.add(new ObjectExp(new Integer(1)));
		inExpList.add(new ObjectExp(new Integer(2)));
		inExpList.add(new ObjectExp(new Integer(3)));
		BoolExpression exp =
			new InExp(targetExp, ExpressionUtil.toExpressionArray(inExpList));
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		ObjectExp targetExp = new ObjectExp(new Integer(2));
		List inExpList = new ArrayList();
		inExpList.add(NullExp.NULL);
		inExpList.add(new ObjectExp(new Integer(2)));
		inExpList.add(new ObjectExp(new Integer(3)));
		BoolExpression exp =
			new InExp(targetExp, ExpressionUtil.toExpressionArray(inExpList));
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		List inExpList = new ArrayList();
		inExpList.add(new ObjectExp(new Integer(1)));
		inExpList.add(new ObjectExp(new Integer(2)));
		inExpList.add(new ObjectExp(new Integer(3)));
		BoolExpression exp =
			new InExp(
				NullExp.NULL,
				ExpressionUtil.toExpressionArray(inExpList));
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate5() throws Exception {
		ObjectExp targetExp = new ObjectExp(new Integer(2));
		List list = new ArrayList();
		list.add(new Integer(1));
		list.add(new Integer(2));
		list.add(new Integer(3));
		BoolExpression exp =
			new InExp(targetExp, new Expression[] { new ObjectExp(list)});
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate6() throws Exception {
		ObjectExp targetExp = new ObjectExp(new Integer(2));
		Integer[] array =
			new Integer[] { new Integer(1), new Integer(2), new Integer(3)};
		BoolExpression exp =
			new InExp(targetExp, new Expression[] { new ObjectExp(array)});
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(InExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(new String[] { InExpTest.class.getName()});
	}
}