package org.seasar.framework.container;

import org.seasar.framework.sel.SelContext;

/**
 * @author higa
 *
 * IoC̃Rei@\񋟂܂B
 */
public interface S2Container {
	
	public String NAME = "s2/container";

	public Object getComponent(Class componentClass)
		throws
			ComponentNotFoundRuntimeException,
			TooManyRegistrationRuntimeException,
			CyclicReferenceRuntimeException;

	public Object getComponent(String componentName)
		throws
			ComponentNotFoundRuntimeException,
			TooManyRegistrationRuntimeException,
			CyclicReferenceRuntimeException;
			
	public void injectDependency(Object outerComponent);
	
	public void injectDependency(Object outerComponent, Class componentClass);
	
	public void injectDependency(Object outerComponent, String componentName);

	public void register(Class componentClass);

	public void register(Class componentClass, String componentName);

	public void register(ComponentDef componentDef);

	public int getComponentDefSize();

	public ComponentDef getComponentDef(int index);

	public ComponentDef getComponentDef(String componentName)
		throws ComponentNotFoundRuntimeException;

	public ComponentDef getComponentDef(Class componentClass)
		throws ComponentNotFoundRuntimeException;
		
	public boolean hasComponentDef(String componentName);
	
	public boolean hasComponentDef(Class componentClass);

	public void include(S2Container child);

	public SelContext getSelContext();

	public void init();

	public void destroy();

}
