package org.seasar.framework.container;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * R|[lg̃vpeBȂƂ̎sO
 */
public class PropertyNotFoundRuntimeException
	extends SRuntimeException {

	private Class componentClass_;
	private String propertyName_;

	public PropertyNotFoundRuntimeException(
		Class componentClass,
		String propertyName) {
		super(
			"ESSR0065",
			new Object[] { componentClass.getName(), propertyName});
		componentClass_ = componentClass;
		propertyName_ = propertyName;
	}

	public Class getComponentClass() {
		return componentClass_;
	}
	
	public String getPropertyName() {
		return propertyName_;
	}
}