package test.org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.boolexps.IsTrueExp;
import org.seasar.framework.sel.exps.BooleanExp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class IsTrueExpTest extends TestCase {

	public IsTrueExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BoolExpression exp = new IsTrueExp(BooleanExp.TRUE);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		BoolExpression exp = new IsTrueExp(BooleanExp.FALSE);
		assertEquals("1", false, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(IsTrueExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { IsTrueExpTest.class.getName()});
	}
}