package test.org.seasar.framework.container.assembler.method;

import java.util.HashMap;

import junit.framework.TestCase;

import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.method.DefaultInitMethodAssembler;
import org.seasar.framework.container.assembler.method.InitMethodAssembler;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author higa
 *
 */
public class DefaultInitMethodAssemblerTest extends TestCase {

	public DefaultInitMethodAssemblerTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DefaultInitMethodAssemblerTest.class);
	}

	public void testAssemble() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
		InitMethodDef md = new InitMethodDefImpl("put");
		ArgDef argDef = new ArgDefImpl("aaa");
		md.addArgDef(argDef);
		ArgDef argDef2 = new ArgDefImpl("111");
		md.addArgDef(argDef2);
		cd.addInitMethodDef(md);
		container.register(cd);
		InitMethodAssembler assembler = new DefaultInitMethodAssembler(cd);
		HashMap map = new HashMap();
		assembler.assemble(map);
		assertEquals("1", "111", map.get("aaa"));
	}

	public void testAssembleIllegalArgument() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
		InitMethodDef md = new InitMethodDefImpl("put");
		cd.addInitMethodDef(md);
		container.register(cd);
		InitMethodAssembler assembler = new DefaultInitMethodAssembler(cd);
		HashMap map = new HashMap();
		try {
			assembler.assemble(map);
			fail("1");
		} catch (MethodNotFoundRuntimeException ex) {
			System.out.println(ex);
		}
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public interface Foo {
		public String getHogeName();
	}

	public static class A implements Foo {

		private Hoge hoge_;

		public A() {
		}

		public Hoge getHoge() {
			return hoge_;
		}

		public void setHoge(Hoge hoge) {
			hoge_ = hoge;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public interface Hoge {

		public String getName();
	}

	public static class B implements Hoge {

		public String getName() {
			return "B";
		}
	}
}