package org.seasar.framework.util.io;

import java.io.InputStream;
import java.net.URL;

import org.seasar.framework.util.net.URLUtil;

public final class ResourceUtil {

	private ResourceUtil() {
	}

	public static String getResourcePath(String path, String extension) {
		if (extension == null) {
			return path;
		}
		extension = "." + extension;
		if (path.endsWith(extension)) {
			return path;
		}
		return path.replace('.', '/') + extension;
	}
	
	public static ClassLoader getClassLoader() {
		return Thread.currentThread().getContextClassLoader();
	}

	public static URL getResource(String path) {
		return getResource(path, null);
	}
	public static URL getResource(String path, String extension)
		throws ResourceNotFoundRuntimeException {

		path = getResourcePath(path, extension);
		URL url = getClassLoader().getResource(path);
		if (url != null) {
			return url;
		} else {
			throw new ResourceNotFoundRuntimeException(path);
		}
	}
	
	public static InputStream getResourceAsStream(String path) {
		return getResourceAsStream(path, null);
	}
		
	public static InputStream getResourceAsStream(String path, String extension) {
		URL url = getResource(path, extension);
		return URLUtil.openStream(url);
	}
}