package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class IsNullExp implements BoolExpression {

	private Expression targetExp_;

	public IsNullExp(Expression targetExp) {
		targetExp_ = targetExp;
	}

	public boolean evaluate(SelContext context) {
		Object target = targetExp_.evaluateValue(context);
		if (target == null) {
			return true;
		} else {
			return false;
		}
	}
}