package org.seasar.framework.container.assembler.property;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org
	.seasar
	.framework
	.container
	.IllegalPropertyConfigurationRuntimeException;
import org.seasar.framework.container.PropertyDef;

/**
 * @author higa
 *
 */
public class ManualPropertyAssembler extends AbstractPropertyAssembler {

	/**
	 * @param componentDef
	 */
	public ManualPropertyAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.assembler.property.PropertyAssembler#assemble(java.lang.Object)
	 */
	public void assemble(Object component) {
		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getPropertyDefSize();
		for (int i = 0; i < size; ++i) {
			PropertyDef propDef = getComponentDef().getPropertyDef(i);
			Object value = null;
			try {
				value = propDef.getValue();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalPropertyConfigurationRuntimeException(
					getComponentDef().getComponentClass(),
					propDef.getPropertyName(),
					cause);
			}
			PropertyDesc propDesc =
				beanDesc.getPropertyDesc(propDef.getPropertyName());
			propDesc.setValue(component, value);
		}
	}

}
