package org.seasar.framework.container.assembler.method;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.IllegalMethodConfigurationRuntimeException;
import org.seasar.framework.container.InitMethodDef;

/**
 * @author higa
 *
 */
public class DefaultInitMethodAssembler
	extends AbstractDestroyMethodAssembler {

	/**
	 * @param componentDef
	 */
	public DefaultInitMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.assembler.method.MethodAssembler#assemble(java.lang.Object)
	 */
	public void assemble(Object component)
		throws IllegalMethodConfigurationRuntimeException {

		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getInitMethodDefSize();
		for (int i = 0; i < size; ++i) {
			InitMethodDef methodDef =
				getComponentDef().getInitMethodDef(i);
			Object[] args = null;
			try {
				args = methodDef.getArgs();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalMethodConfigurationRuntimeException(
					getComponentDef().getComponentClass(),
					methodDef.getMethodName(),
					cause);
			}
			beanDesc.invoke(component, methodDef.getMethodName(), args);
		}
	}

}
