package org.seasar.framework.container.assembler.constructor;

import java.lang.reflect.Constructor;

import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.util.reflect.ClassUtil;
import org.seasar.framework.util.reflect.ConstructorUtil;

/**
 * @author higa
 *
 */
public abstract class AbstractConstructorAssembler
	extends AbstractAssembler
	implements ConstructorAssembler {

	public AbstractConstructorAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	protected final AopProxy createAopProxy() {
		return new AopProxy(
			getComponentDef().getComponentClass(),
			getAspects());
	}

	protected Object assembleDefault() {
		Class clazz = getComponentDef().getComponentClass();
		Constructor constructor = ClassUtil.getConstructor(clazz, null);
		if (getComponentDef().getAspectDefSize() > 0) {
			AopProxy aopProxy = createAopProxy();
			return aopProxy.create();
		} else {
			return ConstructorUtil.newInstance(constructor, null);
		}
	}

	private Aspect[] getAspects() {
		int size = getComponentDef().getAspectDefSize();
		Aspect[] aspects = new Aspect[size];
		for (int i = 0; i < size; ++i) {
			AspectDef aspectDef = getComponentDef().getAspectDef(i);
			aspects[i] = aspectDef.getAspect();
		}
		return aspects;
	}
}
