package org.seasar.framework.container;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * R|[lg̃vpeB̐ݒɎsƂ̎sO
 */
public class IllegalPropertyConfigurationRuntimeException
	extends SRuntimeException {

	private Class componentClass_;
	private String propertyName_;

	public IllegalPropertyConfigurationRuntimeException(
		Class componentClass,
		String propertyName,
		Throwable cause) {
		super(
			"ESSR0059",
			new Object[] { componentClass.getName(), propertyName, cause },
			cause);
		componentClass_ = componentClass;
		propertyName_ = propertyName;
	}

	public Class getComponentClass() {
		return componentClass_;
	}
	
	public String getPropertyName() {
		return propertyName_;
	}
}