package org.seasar.extension.tx;

import javax.transaction.TransactionManager;

import org.seasar.framework.aop.Joinpoint;
import org.seasar.framework.exception.lang.SIllegalStateException;

/**
 * @author higa
 *
 */
public class MandatoryAdvice extends AbstractTxAdvice {
	
	public MandatoryAdvice(TransactionManager transactionManager) {
		super(transactionManager);
	}

	/**
	 * @see org.seasar.framework.aop.AroundAdvice#invoke(org.seasar.framework.aop.Joinpoint)
	 */
	public Object invoke(Joinpoint joinpoint) throws Throwable {
		if (!hasTransaction()) {
			throw new SIllegalStateException("ESSR0311", null);
		} 
		return joinpoint.proceed();
	}
}